<?php

/**
 *  公共任务资源
 */
namespace App\Repositories\Business;


use App\Libraries\Wx\WxApi;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use stdClass;

class TaskRepository
{
    use \App\Helpers\ApiResponse;

    //客户表
    private $business;
    private $business_log;
    private $user;
    private $common_sea_log;

    //初始化需要用到的表名称
    public function __construct()
    {
        $this->user                     = config('db_table.user_table');
        $this->business                 = config('db_table.business_table');
        $this->business_log             = config('db_table.business_log');
        $this->common_sea_log           = config('db_table.common_sea_log');
    }


    /**
     * 检查当天的商机
     */
    public function checkBusiness()
    {
        echo "check_business starting";
        //获取当天所有待领取的商机列表(按升序获取)
        DB::table($this->business." as a")
            ->leftJoin($this->user." as b","a.uid","=","b.uid")
            ->where("a.uid",">",0)
            ->whereIn("a.status",["waiting","running"])
            ->whereDate("a.create_time",date("Y-m-d"))
            ->orderBy("a.create_time","asc")//必须使用
            ->select(["a.customer_id","a.uid","a.name","a.status","b.openid","a.create_time","a.last_follow_time"])
            ->chunk(200,function($list){

                //调入公海条件  1.当天未领取  2.领取了,当天无跟进反馈
                foreach($list as $val)
                {
                    if($val->status == "waiting")
                    {
                        $this->doWaiting($val);
                    }
                    else
                    {
                        $this->doRunning($val);
                    }
                }

            });

        echo "check_business  over";
    }

    /**
     * 历史进行中的商机列表
     */
    public function historyBusiness()
    {
        echo "check_history_business starting";
        DB::table($this->business." as a")
            ->leftJoin($this->user." as b","a.uid","=","b.uid")
            ->where("a.uid",">",0)
            ->where("a.status","running")
            ->where("a.create_time",'<',date("Y-m-d"))
            ->orderBy("a.create_time","asc")//必须使用
            ->select(["a.customer_id","a.uid","a.status","a.next_follow_time","b.openid","a.name","a.last_follow_time"])
            ->chunk(200,function($list){

                foreach($list as $val)
                {
                    //对比下一次的跟进日期
                    if(!empty($val->next_follow_time))
                    {
                        $next_time = strtotime($val->next_follow_time);

                        //提醒时间   倒计时30分钟内发送微信提醒
                        $delayTime = $next_time - 3*60*60;
                        if(time() > $delayTime && time() < $next_time)
                        {
                            //如果今天跟进了，则不提醒
                            if(!empty($val->last_follow_time))
                            {
                                $last_followTime = strtotime($val->last_follow_time);

                                $todayTime = strtotime(date('Y-m-d'));
                                if($last_followTime > $todayTime)
                                    continue ;
                            }

                            if($val->openid)
                                $this->sendMsg($val->openid,$val,$val->next_follow_time,"");
                        }

                        if(time()>$next_time)
                        {
                            //如果今天跟进了，则不提醒
                            if(!empty($val->last_follow_time))
                            {
                                $last_followTime = strtotime($val->last_follow_time);

                                $todayTime = strtotime(date('Y-m-d'));
                                if($last_followTime > $todayTime)
                                    continue ;
                            }

                            $this->doNotFollow($val);
                        }
                    }
                }

            });

        echo "check_history_business  over";
    }


    /**
     * 处理没有及时跟进的商机
     */
    protected  function doNotFollow($params)
    {
        $time = date("Y-m-d H:i:s");

        $desc = "商机未按约定时间[".$params->next_follow_time."]跟进掉入公海";
        //1.将商机信息放入公海  2.记录放入公海的原因
        $update_data = [
            "uid"                   => 0,
            "status"                => "waiting",//公海线索变成待领取状态
            "follow_nums"           => 0,
            "next_follow_time"      => NULL,
            "in_common_sea_remark"  => $desc,
            "in_common_sea_time"    => $time
        ];
        $insert_data = [
            "customer_id"   => $params->customer_id,
            "uid"           => $params->uid,
            "type"          => "not_follow_ontime",//跟进不及时
            "remark"        => $desc,
            "create_time"   => $time
        ];

        //此处需要事务操作
        try{
            DB::transaction(function () use($params,$update_data,$insert_data){
                DB::table($this->business)->where("customer_id",$params->customer_id)->update($update_data);
                DB::table($this->common_sea_log)->insert($insert_data);
            });
        }catch(QueryException $ex){

            $this->failed($ex->getMessage());
            return ;
        }
    }


    /**
     * 处理等待中的商机
     */
    protected function doWaiting($params)
    {
        $createTime = strtotime($params->create_time);
        //获取对应日期的 晚上22点时间戳
        $nightTime  = strtotime('17:00:00',$createTime);
        $showNightTime = date("Y-m-d H:i:s",$nightTime);

        $dayTime = date("Y-m-d",$createTime);

        $time = date("Y-m-d H:i:s");

        //提醒时间   倒计时十分钟内发送微信提醒
        $delayTime = $nightTime - 30*60;
        if(time() > $delayTime && time() < $nightTime)
        {
            if($params->openid)
            $this->sendMsg($params->openid,$params,$showNightTime,"");
        }


        if(time() > $nightTime)//过了当天时间戳的晚上24
        {
            $desc = $dayTime."当天商机未领取掉入公海";
            //1.将商机信息放入公海  2.记录放入公海的原因
            $update_data = [
                "uid"                   => 0,
                "status"                => "waiting",//公海线索变成待领取状态
                "follow_nums"           => 0,
                "in_common_sea_remark"  => $desc,
                "in_common_sea_time"    => $time
            ];
            $insert_data = [
                "customer_id"   => $params->customer_id,
                "uid"           => $params->uid,
                "type"          => "today_not_get",
                "remark"        => $desc,
                "create_time"   => $time
            ];

            //此处需要事务操作
            try{
                DB::transaction(function () use($params,$update_data,$insert_data){
                    DB::table($this->business)->where("customer_id",$params->customer_id)->update($update_data);
                    DB::table($this->common_sea_log)->insert($insert_data);
                });
            }catch(QueryException $ex){
               return;
            }
        }
    }


    /**
     * 处理跟进中的商机
     * @param $params
     */
    protected  function doRunning($params)
    {
        $createTime     = strtotime($params->create_time);
        //最后一次跟进时间戳
        //获取对应日期的 当天下午18点时间戳
        $nightTime      = strtotime('17:30:00',$createTime);//当天截止时间
        $showNightTime  = date("Y-m-d H:i:s",$nightTime);

        $time = date("Y-m-d H:i:s");

        if(!empty($params->last_follow_time))
        {
            $last_followTime = strtotime($params->last_follow_time);

            $todayTime = strtotime(date('Y-m-d'));
            if($last_followTime > $todayTime)
                return ;
        }


        //提醒时间   倒计时30分钟内发送微信提醒
        $delayTime = $nightTime - 30*60;
        if(time() > $delayTime && time() < $nightTime)
        {
            if($params->openid)
                $this->sendMsg($params->openid,$params,$showNightTime,"");
        }

        //当前时间大于截止时间   并且当天存在跟进
        if(time() > $nightTime)//过了当天时间戳
        {
            //判断当天是否跟进了商机
            $row = DB::table($this->business_log)->where("customer_id",$params["customer_id"])->whereDate('created_time',date("Y-m-d"))->where("operate_type","follow")->first();
            if(!empty($row))
                return;

            $desc = $nightTime."商机未跟进掉入公海";
            //1.将商机信息放入公海  2.记录放入公海的原因
            $update_data = [
                "uid"                   => 0,
                "status"                => "waiting",//公海线索变成待领取状态
                "follow_nums"           => 0,
                "in_common_sea_remark"  => $desc,
                "in_common_sea_time"    => $time
            ];
            $insert_data = [
                "customer_id"   => $params->customer_id,
                "uid"           => $params->uid,
                "type"          => "today_not_follow",
                "remark"        => $desc,
                "create_time"   => $time
            ];

            //此处需要事务操作
            try{
                DB::transaction(function () use($params,$update_data,$insert_data){
                    DB::table($this->business)->where("customer_id",$params->customer_id)->update($update_data);
                    DB::table($this->common_sea_log)->insert($insert_data);
                });
            }catch(QueryException $ex){
                return ;
            }
        }
    }





    /**
     * 发送模板消息
     * @param $openid
     * @param $data
     * @param $url
     */
    public function sendMsg($openid,$data,$deadtime,$url)
    {
        //
        //$templateId = "oghDta_s0k5gsBzbLv_9HV88I737A2_-sQMiqscrsiI";
        $templateId = "bX3SO-j1h7VfhYQ_iCM_OBo-HLtnzsRBMP96DZi6Bw0";
        // 发送模板消息
        $first = "您有客户线索即掉入公海";
        $wxdata = [
            'touser'        => $openid,
            'template_id'   => $templateId,
            'url'           => $url,
            'data'          => [
                    'first'     => ['value' => $first, 'color' => '#FE2500'],
                    'keyword1'  => ['value' => "商机管理系统", 'color' => ''],//报警位置
                    'keyword2'  => ['value' => date("Y-m-d H:i:s"), 'color' => ''],//报警时间
                    'keyword3'  => ['value' => "您的商机客户:".$data->name."将在".$deadtime."掉入公海", 'color' => '#2490DD'],//报警内容
                    //'remark'    => ['value' => '点击进入管理小店或关闭通知。', 'color' => ''],
            ]
        ];

        try{
            WxApi::getInstance()->templateSend(WxApi::getInstance()->accessToken(), $wxdata);
        }catch (\Exception $e){
            Log::info('推送模板消息失败:'.$e->getMessage());
        }
    }
}