<?php

/**
 *  上传视频资源
 */
namespace App\Repositories\Business;

use Illuminate\Support\Facades\DB;

class VideoRepository
{
    use \App\Helpers\ApiResponse;

    private $video_table;//视频地址表

    //初始化需要用到的表名称
    public function __construct()
    {
        $this->video_table     = config('db_table.video_table');
    }

    /**
     * 添加视频信息
     */
    public function add($params)
    {
        $data = [
            "source"        => $params["source"],
            "domain"        => $params["domain"],
            "title"         => $params["title"],
            "type"          => $params["type"],//业务类型
            "bucket"        => $params["bucket"],
            "url"           => $params["url"],
            "author"        => $params["author"],
            "create_date"   => date("Y-m-d")
        ];

        $bool = DB::table($this->video_table)->insert($data);

        return $bool;
    }

}