<?php


namespace App\Repositories\Common;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CommonUtil
{
    /**
     * 获取字母对应的数字（自定义的转换规则）
     * @param $param
     * @return string
     */
    public function formatWord($param) {
        $explode = explode('-', $param);
        if (sizeof($explode) !=2) {
            return 0;
        }
        $words = explode('.', $explode[1]);
        $word = $words[0];
        $data = ['o'=>0 ,'a'=>1,'b'=>2,'c'=>3,'d'=>4,'e'=>5,'f'=>6,'g'=>7,'h'=>8,'i'=>9];
        $num = '';
        for ($i =0; $i < strlen($word); $i++) {
            if (!empty($word[$i])) {
                $num .= $data[$word[$i]];
            }
        }
        return $num;
    }

    /**
     * 查询商户对应的支付url
     *
     * @param $orgId
     * @return string
     */
    public function getOrgPayUrl($orgId) {
        $config = DB::table('tf_pay_config')
            ->where('org_id', '=', $orgId)
            ->first();
        $config = json_decode(json_encode($config), true);
        $url = '';
        if (!empty($config)) {
            $url = 'http://'.$config['url'];
        }
        return $url;
    }

    /**
     * 获取uid
     *
     * @return int|string|null
     */
    public function getUid() {
        $origin = $_SERVER['HTTP_ORIGIN'] ?? null;
        if (empty($origin)) {
            // $origin = "http://wx-aboh.tenghuiwangxiao.com";//用于支付宝接口测试，上线删除
            return null;
        }
        $url = null;
        $explode = explode('//', $origin);
        if (sizeof($explode) == 2) {
            $url = $explode[1];
        }
        if (empty($url)) {
            return null;
        }
        $config = DB::table('tf_pay_config')
            ->where('url', '=', $url)
            ->first();
        $config = json_decode(json_encode($config), true);
        if (empty($config)) {
            return null;
        }

        return $config['org_id'];
    }
}