<?php
namespace App\Repositories\Common;

class Curl{
    /**
     * @brief get请求
     * @param $url 请求的url
     * @param array $param 请求的参数
     * @param int $timeout 超时时间
     * @param int $log 是否启用日志
     * @return mixed
     */
    public static function get($url, $param=array(), $timeout=10, $log=1){
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); // 允许 cURL 函数执行的最长秒数

        $data = curl_exec($ch);

        if ($log) {
            $data .= "";
        }
        curl_close($ch);

        return $data;
    }

    /**
     * @brief post请求
     * @param $url 请求的url地址
     * @param array $param 请求的参数
     * @param int $log 是否启用日志
     * @return mixed
     */

    public static function post($url, $param=array(), $header=array(), $timeout=10, $log=1){

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); //设置超时时间

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //返回原生的(Raw)输出

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

        curl_setopt($ch, CURLOPT_POST, 1); //POST

        curl_setopt($ch, CURLOPT_POSTFIELDS, $param); //post数据


        if ($header) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        }

        $data = curl_exec($ch);

        if ($log) {
            $data .= "";
        }

        curl_close($ch);

        return $data;
    }

}