<?php

/*
 * 商户流水资源
 */

namespace App\Repositories\Common;

use App\Libraries\OSS\OssClient;
use Illuminate\Support\Facades\DB;


class FileRepository
{
    protected $model;

    use \App\Repositories\BaseRepository;
    use \App\Helpers\ApiResponse;



    public function getPic($params){

        $page=!empty($params['page'])?$params['page']:1;
        $nums=!empty($params['nums'])?$params['page']:10;

        $list=$this->page_api($where = array(['is_pic','=',1]),$nums, $page , $sortColumn = 'create_time', $sort = 'DESC');

        foreach ($list as $k=>$v){
            //如果是云存储图片
            if($v['is_remote']){
                $picList[$k]['pic_url']='http://'.$v['bucket'].'.'.config('serve.endpoint').$v['path'].'/'.$v['filename'];
            }
            else{
                $picList[$k]['pic_url'] = config('serve.static_url') . $v['path'] . '/' . $v['filename'];
            }

            $picList[$k]['fid'] = $v['fid'];
            $picList[$k]['client_name'] = $v['client_name'];
            $picList[$k]['is_choice'] = false;

        }
        $count=$this->count();

        return array(
            'list'=>$picList,
            'count'=>$count
        );

    }



    //上传图片到阿里云OSS，格式为base64
    public function ossUploadBase64($content,$filepath,$filename){

        $ossClient=new OssClient(config('serve.accessKeyId'),config('serve.accessKeySecret'),config('serve.endpoint'));

        $bucket=config('serve.bucket');

        $object=$filepath.$filename;

        try{
            $ossClient->putObject($bucket, $object, $content);
        } catch(OssException $e) {
            // return $e->getMessage();
            return false;
        }

        return array(
            'bucket'=>$bucket,
            'endpoint'=>config('serve.endpoint'),
            'object'=>$object
        );

    }

    public function getFileByMD5($md5)
    {

        $record = DB::table("file")
            ->where("md5","=",$md5)
            ->get();

        if (count($record->toArray()) == 0){
            return Null;
        }

        $record = $record->toArray()[0];


        $record = json_decode(json_encode($record),true);

        $record["url"] = 'http://'.config('serve.bucket').'.'.config('serve.endpoint').'/'.$record["path"].'/'.$record["filename"];
        return $record;

    }




    public function getFileByFid($fid){

        $record=$this->getById($fid);

        if(empty($record))
            return Null;

        return 'http://'.config('serve.bucket').'.'.config('serve.endpoint').'/'.$record->path.'/'.$record->filename;

    }

    //上传图片到阿里云OSS
    public function ossUploadFile($content,$filepath,$filename){

        $ossClient=new OssClient(config('serve.accessKeyId'),config('serve.accessKeySecret'),config('serve.endpoint'));

        $bucket=config('serve.bucket');

        $object=$filepath.'/'.$filename;

        try{
            $ossClient->uploadFile(config('serve.bucket'), $object, $content);
        } catch(OssException $e) {

            return false;
        }

        return array(
            'bucket'=>$bucket,
            'endpoint'=>config('serve.endpoint'),
            'object'=>$object
        );


    }

    

    /*
     * 上传文件的参数
     *
     */
    public function ossUpload($params){


        $file=new File();

        $temp=$params->path();

        $file->filename=$filename= getMicroTime().'.'.$params->getClientOriginalExtension();


        $ret=$this->ossUploadFile($temp,'uploads/'.date('Y/m/d'),$filename);

        if(!$ret)
            return false;

        $file->path='/uploads/'.date('Y/m/d');

        $file->file_type=$params->getClientMimeType();

        $file->suffix=$params->getClientOriginalExtension();

        $file->is_pic=in_array($params->getClientOriginalExtension(),['png','jpg','gif','jpeg','bmp'])?1:0;


        $file->md5=md5_file($params->path());

        $file->client_name=$params->getClientOriginalName();

        $file->file_size=$params->getClientSize();

        $file->is_remote=1;

        $file->bucket=config('serve.bucket');

        $file->create_time=date('Y-m-d H:i:s');

        if(!$file->save())
             return false;

        return 'http://'.config('serve.bucket').'.'.config('serve.endpoint').'/'.$file->path.'/'.$file->filename;


    }

}