<?php


namespace App\Repositories\Common;

require_once '../vendor/autoload.php';

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use QCloud\COSSTS\Sts;
use TencentCloud\Common\Credential;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Cvm\V20170312\Models\DescribeInstancesRequest;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Cvm\V20170312\CvmClient;
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Sms\V20210111\SmsClient;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SmsUtil
{
    use \App\Helpers\ApiResponse;

    /**
     * 发送短信验证码
     *
     * @param $area
     * @param $phone
     * @param $orgId
     * @return mixed|string
     */
    public function sendSms( $phone, $type) {
        try {
            $is = Db::table('emailmessage_log')->where('address',$phone)->orderBy('time','desc')->first();
            if(!empty($is) && (time()-$is->time) < 120){
                $this->failed('两分钟内不能重复发送短信');
            }
            $cred = new Credential("AKIDnPlrhGYaLp3zf4E7k7F6g05tQgfOq0tX", "OWifMnxqTosfBQO5VkiPq1wax4uSjkUx");
            $httpProfile = new HttpProfile();
            $httpProfile->setEndpoint("sms.tencentcloudapi.com");

            $clientProfile = new ClientProfile();
            $clientProfile->setHttpProfile($httpProfile);
            $client = new SmsClient($cred, "ap-guangzhou", $clientProfile);

            $req = new SendSmsRequest();
            $code = rand(pow(10,(4-1)), pow(10,4)-1)."";
            $templateId = "1281607";
            $signName = "腾慧科技";
        
            $params = array(
                "PhoneNumberSet" => array($phone),
                "SmsSdkAppId" => "1400623842",
                "SignName" => $signName,
                "TemplateId" => $templateId,
                "TemplateParamSet" => array($code)
            );
            $req->fromJsonString(json_encode($params));

            $resp = $client->SendSms($req);
            if ($resp->getSendStatusSet()[0]->Code == 'Ok') {
                $key = 'sms-code-'.$phone;
                $log['address'] = $phone;
                $log['code'] = $code;
                $log['time'] = time();
                $log['add_time'] = date('Y-m-d H:i:s');
                $li = Db::table('emailmessage_log')->insertgetid($log);
                if($li < 1){
                    Log::stack(['daily'])->info("短信写入数据库失败", ['phone'=>$phone, 'code'=>$code, 'result'=>json_encode($resp)]);
                    return false;
                }
            }
            Log::stack(['daily'])->info("发送短信", ['phone'=>$phone, 'result'=>json_encode($resp)]);
            return true;
        }
        catch(TencentCloudSDKException $e) {
            Log::stack(['daily'])->info("发送短信失败", ['phone'=>$phone, 'code'=>$code, 'error'=>$e]);
            return false;
        }
    }

    /**
     * 校验短信验证码
     *
     * @param $area
     * @param $phone
     * @param $code
     * @param $orgId
     * @return false
     */
    public function checkSmsCode($area, $phone, $code, $orgId) {
        if (empty($code)) {
            return false;
        }
        if (!empty($area)) {
            $phone = '+'.$area.$phone;
        }
        $key = 'sms-code-'.$orgId.'-'.$phone;
        $incrKey = $key . '-times';
        Redis::select(11);
        $incr = Redis::incr($incrKey);
        Redis::expire($incrKey, 5 * 60);
        if ($incr > 5) {
            Redis::del($key);
            Redis::del($incrKey);
            return false;
        }
        $value = Redis::get($key);

        if ($code == $value) {
            Redis::del($key);
            Redis::del($incrKey);
            return true;
        }
        return false;
    }

    /**
     * 获取cos临时
     */
    public function getCosSign() {
        $sts = new Sts();
        $config = array(
            'url' => 'https://sts.tencentcloudapi.com/',
            'domain' => 'sts.tencentcloudapi.com', // 域名，非必须，默认为 sts.tencentcloudapi.com
            'proxy' => '',
            'secretId' => 'AKIDnPlrhGYaLp3zf4E7k7F6g05tQgfOq0tX', // 固定密钥,若为明文密钥，请直接以'xxx'形式填入，不要填写到getenv()函数中
            'secretKey' => 'OWifMnxqTosfBQO5VkiPq1wax4uSjkUx', // 固定密钥,若为明文密钥，请直接以'xxx'形式填入，不要填写到getenv()函数中
            'bucket' => 'tengface-live-user-1308721187', // 换成你的 bucket
            'region' => 'ap-guangzhou', // 换成 bucket 所在园区
            'durationSeconds' => 180, // 密钥有效期
            'allowPrefix' => '*', // 这里改成允许的路径前缀，可以根据自己网站的用户登录态判断允许上传的具体路径，例子： a.jpg 或者 a/* 或者 * (使用通配符*存在重大安全风险, 请谨慎评估使用)
            // 密钥的权限列表。简单上传和分片需要以下的权限，其他权限列表请看 https://cloud.tencent.com/document/product/436/31923
            'allowActions' => array (
                // 简单上传
                'name/cos:PutObject',
                'name/cos:PostObject',
                // 分片上传
                'name/cos:InitiateMultipartUpload',
                'name/cos:ListMultipartUploads',
                'name/cos:ListParts',
                'name/cos:UploadPart',
                'name/cos:CompleteMultipartUpload'
            )
        );

        // 获取临时密钥，计算签名
        try {
            return $sts->getTempKeys($config);
        } catch (\Exception $e) {
            echo $e;
        }
        return null;
    }
}