<?php

// This file is auto-generated, don't edit it. Thanks.
namespace App\Repositories\Common;

use AlibabaCloud\SDK\Sts\V20150401\Sts;
use \Exception;
use AlibabaCloud\Tea\Exception\TeaError;
use AlibabaCloud\Tea\Utils\Utils;

use Darabonba\OpenApi\Models\Config;
use AlibabaCloud\SDK\Sts\V20150401\Models\AssumeRoleRequest;
use AlibabaCloud\Tea\Utils\Utils\RuntimeOptions;

class StsRepository{

    /**
     * 使用AK&SK初始化账号Client
     * @param string $accessKeyId
     * @param string $accessKeySecret
     * @return Sts Client
     */
    public static function createClient($accessKeyId, $accessKeySecret){
        $config = new Config([
            // 您的 AccessKey ID
            "accessKeyId" => $accessKeyId,
            // 您的 AccessKey Secret
            "accessKeySecret" => $accessKeySecret
        ]);
        // 访问的域名
        $config->endpoint = "sts.cn-beijing.aliyuncs.com";
        return new Sts($config);
    }

    /**
     * @param string[] $args
     * @return void
     */
    public static function main($accessKeyId, $accessKeySecret,$roleSessionName){
        $client = self::createClient($accessKeyId, $accessKeySecret);
        $assumeRoleRequest = new AssumeRoleRequest([
            "roleArn" => "acs:ram::1614523203363225:role/moren",
            "roleSessionName" => $roleSessionName
        ]);
        $runtime = new RuntimeOptions([]);
        try {
            // 复制代码运行请自行打印 API 的返回值
            $msg = $client->assumeRoleWithOptions($assumeRoleRequest, $runtime);
            return $msg->toMap();
        }
        catch (Exception $error) {
            if (!($error instanceof TeaError)) {
                $error = new TeaError([], $error->getMessage(), $error->getCode(), $error);
            }
            // 如有需要，请打印 error
            return $error->message;
        }
    }
}
