<?php

/**
 *  腾讯云上传资源
 */
namespace App\Repositories\Common;

use QCloud\COSSTS\Sts;

class TencentCloudRepository
{

    private $bucket;
    private $secretId;
    private $secretKey;


    public function __construct(){
        $this->bucket           = config('tencent.bucket');
        $this->secretId         = config('tencent.secretId');
        $this->secretKey        = config('tencent.secretKey');
    }

    /***
     * 获取令牌
     * @param $type = pic 图片    video  视频
     * @param $allowDirPrefix 允许的上传目录（header 头部可能需要配置 配置多个防止未命中状态）
     * @return mixed
     */
    public function getPolicy($type = 'pic',$allowDirPrefix = 'pic/*')
    {
        $sts = new Sts();//"qcloud_sts/qcloud-sts-sdk": "3.0.*",
        $config = [
            'url'       => 'https://sts.tencentcloudapi.com/',
            'domain'    => 'sts.tencentcloudapi.com',
            'proxy'     => '',
            'secretId'  => $this->secretId, // 固定密钥
            'secretKey' => $this->secretKey, // 固定密钥
            'bucket'    => $this->bucket, // 换成你的 bucket
            'region'    => 'ap-shanghai', // 换成 bucket 所在园区
            'durationSeconds'   => 18000, // 密钥有效期
            'allowPrefix'       => $allowDirPrefix, // 这里改成允许的路径前缀，可以根据自己网站的用户登录态判断允许上传的具体路径，例子： a.jpg 或者 a/* 或者 * (使用通配符*存在重大安全风险, 请谨慎评估使用)
            // 密钥的权限列表。简单上传和分片需要以下的权限，其他权限列表请看 https://cloud.tencent.com/document/product/436/31923
            'allowActions' => [
                // 简单上传
                'name/cos:PutObject',
                'name/cos:PostObject',
            ]
        ];
        if($type == "video")
        {
            $config['allowPrefix']  = $allowDirPrefix;
            $config['allowActions'] = [
                // 分片上传
                'name/cos:PutObject',
                'name/cos:PostObject',
                'name/cos:PutObject',
                'name/cos:PostObject',
                'name/cos:InitiateMultipartUpload',
                'name/cos:ListMultipartUploads',
                'name/cos:ListParts',
                'name/cos:UploadPart',
                'name/cos:CompleteMultipartUpload',
                'name/cos:uploadFiles',
                'name/cos:SliceUploadFile'
            ];
        }


        // 获取临时密钥，计算签名
        $tempKeys = $sts->getTempKeys($config);
        return json_encode($tempKeys);
    }
}