<?php

/**
 *  支付宝支付资源
 */
namespace App\Repositories\Wechat;

use Yansongda\Pay\Pay;
use Illuminate\Support\Facades\DB;

class AlipayRepository
{
    use \App\Helpers\ApiResponse;

    //初始化表信息
    public function __construct()
    {

    }


    /**
     * 唤起支付
     * @param $orderNo
     * @param $money
     * @param $title
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Yansongda\Pay\Exceptions\InvalidConfigException
     * @throws \Yansongda\Pay\Exceptions\InvalidSignException
     */
    public function index($orderNo, $money, $title, $aliAppid, $publicKey, $privateKey,$type)
    {
        $aliPayOrder = [
            'out_trade_no' => $orderNo,
            'total_amount' => $money, // 支付金额
            'subject'      => $title // 备注
        ];

        $config = config('alipay.pay');
        $config['app_id'] = $aliAppid;
        $config['ali_public_key'] = $publicKey;
        $config['private_key'] = $privateKey;
        // $str = my_encrypt((String)$orderNo, "order_id");

        $config['notify_url'] = $config['notify_url'];
        switch($type){
            case 0:
                $config['return_url'] = $config['return_url'];
                return Pay::alipay($config)->web($aliPayOrder);
            case 1:
                $config['return_url'] = 'http://m.kzschool.com/#/pages/My/myorder/index';
                return Pay::alipay($config)->wap($aliPayOrder);
            case 2:
                $config['return_url'] = $config['return_url'];
                return Pay::alipay($config)->app($aliPayOrder);
        }
    }

    public function userwithdrawal($with_no,$money,$title, $aliAppid, $publicKey, $privateKey,$identity){
        $aliPayOrder = [
            'out_biz_no' => $with_no,
            'trans_amount' => $money, 
            'product_code' => 'TRANS_ACCOUNT_NO_PWD', 
            'biz_scene' => 'DIRECT_TRANSFER', 
            'order_title' => $title, 
            'payee_info' => [
                'identity'=>$identity,
                'identity_type'=>'ALIPAY_USER_ID'
            ]
        ];
        $config = config('alipay.pay');
        $config['app_id'] = $aliAppid;
        $config['ali_public_key'] = $publicKey;
        $config['private_key'] = $privateKey;
        $param =  Pay::alipay($config)->Transfer($aliPayOrder);
        print_r($param);
    }
}