<?php

/**
 *  订单资源
 */
namespace App\Repositories\Wechat;

use App\Repositories\Common\CommonUtil;
use Illuminate\Support\Facades\DB;

class OrderRepository
{
    use \App\Helpers\ApiResponse;

    private $order;
    private $payUrl;

    //初始化表信息
    public function __construct()
    {
        $this->order        = "sc_order";
        $this->payUrl       = "sc_pay_url";
    }


    /**
     *
     */
    public function lists($params,$needCount = true)
    {
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $where = [];
        isset($params["order_no"]) && $where[] = ["pay_order_sn","=",$params["order_no"]];

        if($needCount)
        {
            $count = DB::table($this->order)->where($where)->count();
            if($count == 0)
                return ["count"=>0,"list"=>null];

            $data["count"] = $count;
        }

        $list = DB::table($this->order)
            ->where($where)
            ->where('org_id', '=', UID)
            ->orderby("create_time","desc")
            ->offset($offset)
            ->limit($page_nums)
            ->get();


        foreach($list as &$val)
        {
            $val->order_no = $val->pay_order_sn;
        }

        $data["list"] = $list;

        $this->success($data);
    }


    public function add($type,$money,$uid)
    {
        $order_no = date('Ymd').time().rand_code(5).rand(10000,99999);

        $data = [
            "order_no"      => $order_no,
            "type"          => $type,
            "ip"            => $_SERVER["REMOTE_ADDR"],
            "money"         => $money*100,
            "org_id"        => $uid,
            "pay_status"    => "no",
            "details_time"  => date('Y-m-d')
        ];

        DB::table($this->order)->insertGetId($data);

        //$payOrderId = 100000000+sprintf("%06d", $orderId);

        return $order_no;
    }


    public function payList($params,$needCount=true)
    {
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $where = [];
        if($needCount)
        {
            $count = DB::table($this->payUrl)->where($where)->count();
            if($count == 0)
                return ["count"=>0,"list"=>null];

            $data["count"] = $count;
        }

        $list = DB::table($this->payUrl)
            ->where($where)
            ->where('org_id', '=', UID)
            ->orderby("create_time","desc")
            ->offset($offset)
            ->limit($page_nums)
            ->get();

        $commonUtil = new CommonUtil();
        $orgPayUrl = $commonUtil->getOrgPayUrl(UID);
        if (empty($orgPayUrl)) {
            $this->failed("未配置支付域名");
        }
        foreach($list as &$val)
        {
            $val->money = number_format($val->money/100, 2);
            $val->url = $orgPayUrl."?money=".$val->money;
        }

        $data["list"] = $list;

        return $data;
    }


    /**
     * 生成支付链接
     */
    public function makepayUrl($title,$money)
    {
        $data = [
            "title" => $title,
            "money" => $money,
            "org_id"   => UID
        ];

        $realMoney = $money/100;
        $data["encryt_money"] = my_encrypt((String)$realMoney,"money");

        DB::table($this->payUrl)->insert($data);
        $commonUtil = new CommonUtil();
        $orgPayUrl = $commonUtil->getOrgPayUrl(UID);
        if (empty($orgPayUrl)) {
            $this->failed("未配置支付域名");
        }
        return $orgPayUrl."/?money=".$realMoney;
    }


    public function info($orderNo, $uid)
    {
        $row = DB::table($this->order)->where("order_no",$orderNo)->where("org_id", $uid)->first();
        if(empty($row))
            $this->failed("非法请求".$orderNo);

        $config = DB::table('tf_pay_config')
            ->where('org_id', '=', $uid)
            ->first();
        $config = json_decode(json_encode($config), true);
        if (empty($config)) {
            $this->failed("数据异常");
        }
        $data = [
            "company_name"  => $config['name'],
            "order_no"      => $row->pay_order_sn,
            "order_money"   => $row->money,
            "type"          => $row->type,
            "pay_time"      => $row->pay_time,
        ];

        return $data;
    }
}