<?php

namespace App\Repositories\Wechat;

use WeChatPay\Formatter;
use WeChatPay\Builder;
use WeChatPay\Crypto\Rsa;
use WeChatPay\Util\PemUtil;

class WechatPay{

    private $instance;
 //php -f ./bin/CertificateDownloader.php -- -k 1e0abebdb7de4598747de0de20da8e84 -m 1614109949 -f /www/wwwroot/kuaizheng-api/wechatpay/apiclient_key.pem -s 54116FD9271A304C585E5BE4B867B9A0E6FFF552
    
    public function __construct(){
         // 设置参数
        require_once('../vendor/autoload.php');
        // 商户号
        $merchantId = '1614109949';

        // 从本地文件中加载「商户API私钥」，「商户API私钥」会用来生成请求的签名
        $merchantPrivateKeyFilePath = 'file:///www/wwwroot/kuaizheng-api/wechatpay/apiclient_key.pem';
        $merchantPrivateKeyInstance = Rsa::from($merchantPrivateKeyFilePath, Rsa::KEY_TYPE_PRIVATE);
        
        // 「商户API证书」的「证书序列号」
        $merchantCertificateSerial = '54116FD9271A304C585E5BE4B867B9A0E6FFF552';

        // 从本地文件中加载「微信支付平台证书」，用来验证微信支付应答的签名
        $platformCertificateFilePath = 'file:///tmp/wechatpay_2A574CB3490A4F6F098623C1A565632C2EFF09F9.pem';
        $platformPublicKeyInstance = Rsa::from($platformCertificateFilePath, Rsa::KEY_TYPE_PUBLIC);

        // 从「微信支付平台证书」中获取「证书序列号」
        $platformCertificateSerial = PemUtil::parseCertificateSerialNo($platformCertificateFilePath);

        // 构造一个 APIv3 客户端实例
        $this->instance = Builder::factory([
            'mchid'      => $merchantId,
            'serial'     => $merchantCertificateSerial,
            'privateKey' => $merchantPrivateKeyInstance,
            'certs'      => [
                $platformCertificateSerial => $platformPublicKeyInstance,
            ],
        ]);
    }

    //PC支付
    public function pcpay($oid,$msg,$price){
        try {
            $resp = $this->instance
            ->chain('v3/pay/transactions/native')
            ->post(['json' => [
                'mchid'        => '1614109949',
                'out_trade_no' => $oid,
                'appid'        => 'wx13af654110dba459',
                'description'  => $msg,
                'notify_url'   => 'https://api.kzschool.com/wechat/wxpay/callback',
                'amount'       => [
                    'total'    => $price,
                    'currency' => 'CNY'
                ],
            ]]);
            // $resu = json_decode($resp->getBody(),true);
            echo $resp->getBody();
        } catch (\Exception $e) {
            // 进行错误处理
            echo $e->getMessage();
            if ($e instanceof \GuzzleHttp\Exception\RequestException && $e->hasResponse()) {
                $r = $e->getResponse();
                // echo $r->getStatusCode() . ' ' . $r->getReasonPhrase(), PHP_EOL;
                echo $r->getBody();
            }
            // echo $e->getTraceAsString(), PHP_EOL;
        }
    }

        //h5支付
    public function h5pay($oid,$msg,$price){
        try {
            $resp = $this->instance
            ->chain('v3/pay/transactions/h5')
            ->post(['json' => [
                'mchid'        => '1614109949',
                'out_trade_no' => $oid,
                'appid'        => 'wx13af654110dba459',
                'description'  => $msg,
                'notify_url'   => 'https://api.kzschool.com/wechat/wxpay/callback',
                'amount'       => [
                    'total'    => $price,
                    'currency' => 'CNY'
                ],
                'scene_info'    =>[
                    'payer_client_ip'=>get_onlineip(),
                    'h5_info'   =>[
                        'type'  =>'Wap'
                    ]
                ]
            ]]);
            // $resu = json_decode($resp->getBody(),true);
            echo $resp->getBody();
        } catch (\Exception $e) {
            echo $e->getMessage();
            if ($e instanceof \GuzzleHttp\Exception\RequestException && $e->hasResponse()) {
                $r = $e->getResponse();
                // echo $r->getStatusCode() . ' ' . $r->getReasonPhrase(), PHP_EOL;
                echo $r->getBody();
            }
        }
    }

        //jsapi支付
    public function jsapipay($oid,$msg,$price){
        try {
            $resp = $this->instance
            ->chain('v3/pay/transactions/native')
            ->post(['json' => [
                'mchid'        => '1614109949',
                'out_trade_no' => $oid,
                'appid'        => 'wx13af654110dba459',
                'description'  => $msg,
                'notify_url'   => 'https://api.kzschool.com/wechat/wxpay/callback',
                'amount'       => [
                    'total'    => $price,
                    'currency' => 'CNY'
                ],
            ]]);
            // $resu = json_decode($resp->getBody(),true);
            echo $resp->getBody();
        } catch (\Exception $e) {
            $r = $e->getResponse();
            echo $r->getBody();
        }
    }   
    
        //app支付
    public function apppay($oid,$msg,$price){
        try {
            $resp = $this->instance
            ->chain('v3/pay/transactions/app')
            ->post(['json' => [
                'mchid'        => '1614109949',
                'out_trade_no' => $oid,
                'appid'        => 'wxf28a5ea9af176127',
                'description'  => $msg,
                'notify_url'   => 'https://api.kzschool.com/wechat/wxpay/callback',
                'amount'       => [
                    'total'    => $price,
                    'currency' => 'CNY'
                ]
            ]]);
            $resu = json_decode($resp->getBody(),true);
            $sign = $this->appsign($resu['prepay_id']);
            $return = json_decode($sign,true);
            $return['partnerid'] = '1614109949';
            $return['prepay_id'] = $resu['prepay_id'];
            return json_encode($return);
        } catch (\Exception $e) {
            echo $e->getMessage();
            if ($e instanceof \GuzzleHttp\Exception\RequestException && $e->hasResponse()) {
                $r = $e->getResponse();
                echo $r->getBody();
            }
        }
    }       

    //签名
    private function appsign($pid){
        $merchantPrivateKeyFilePath = 'file:///www/wwwroot/kuaizheng-api/wechatpay/apiclient_key.pem';
        $merchantPrivateKeyInstance = Rsa::from($merchantPrivateKeyFilePath);

        $params = [
            'appId'     => 'wxf28a5ea9af176127',
            'timeStamp' => (string)Formatter::timestamp(),
            'nonceStr'  => Formatter::nonce(),
            'prepayid'   => $pid,
        ];
        $params += ['sign' => Rsa::sign(
            Formatter::joinedByLineFeed(...array_values($params)),
            $merchantPrivateKeyInstance
        ), 'signType' => 'RSA'];
        return json_encode($params);
    }
}





