<?php
error_reporting(-1);

ini_set('display_errors', 'On');

class Firebase{

    public function send($to, $message) {
       $fields = array(
            'to'=> $to,
            'data'=> $message,
        );
        return $this->sendPushNotification($fields);
    }
        
    public function sendToTopic($to, $message) {
        $fields= array(
        'to'=> '/topics/'. $to,
        'data'=> $message,
        );
       return $this->sendPushNotification($fields);
    } 

    public function sendMultiple($registration_ids, $message) {
        $fields= array(
        'to'=> $registration_ids,
        'data'=> $message,
         );
        return $this->sendPushNotification($fields);
    }

    private function sendPushNotification($fields) {
        require_once __DIR__ . '/config.php';
        
        $url= 'https://fcm.googleapis.com/fcm/send';
        
        $headers= array(
        'Authorization: key='. FIREBASE_API_KEY,
        'Content-Type: application/json'
        );
        
        $ch= curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result= curl_exec($ch);
        if($result=== FALSE) {
            die('Curl failed: '. curl_error($ch));
        }
        curl_close($ch);
        return $result;
    }
}


class Push {

    private $title;

    private $message;

    private $image;

    private $data;

    private $is_background;

    public function setTitle($title) {
    $this->title = $title;
    }

    public function setMessage($message) {

    $this->message = $message;

    }

    public function setImage($imageUrl) {

    $this->image = $imageUrl;

    }

    public function setPayload($data) {

    $this->data = $data;

    }

    public function setIsBackground($is_background) {

    $this->is_background = $is_background;

    }

    public function getPush() {

    $res= array();

    $res['data']['title'] = $this->title;

    $res['data']['is_background'] = $this->is_background;

    $res['data']['message'] = $this->message;

    $res['data']['image'] = $this->image;

    $res['data']['payload'] = $this->data;

    $res['data']['timestamp'] = date('Y-m-d G:i:s');

    return$res;

    }

}


$firebase= new Firebase();

$push= new Push();

$payload= array();

$payload['team'] = 'India';

$payload['score'] = '5.6';

$title= isset($_GET['title']) ? $_GET['title'] : '222222';

$message= isset($_GET['message']) ? $_GET['message'] : '3333333';

$push_type= isset($_GET['push_type']) ? $_GET['push_type'] : 'individual';

$include_image= isset($_GET['include_image']) ? TRUE : FALSE;

$push->setTitle($title);

$push->setMessage($message);

if($include_image) {

$push->setImage('https://api.androidhive.info/images/minion.jpg');

} else{

$push->setImage('');

}

$push->setIsBackground(FALSE);

$push->setPayload($payload);

$json= '';

$response= '';

if($push_type== 'topic') {

$json= $push->getPush();

$response= $firebase->sendToTopic('global', $json);

} elseif($push_type== 'individual') {

$json= $push->getPush();

$regId= isset($_GET['regId']) ? $_GET['regId'] : 'fbcBkMrOQS6npF9Ku9nMXE:APA91bHExZnV5fGJ7VSkDK03iZKmygfRLGN-0OWizW7NbgR0h7FFtOTZGSrJuDFNqjh97IDLVCgt-h5neW9BLlizOVe432Xj4KUakx2xmtSXncHKU92nn3KEXjwVScyFnrBZkRmiGj8o';

$response= $firebase->send($regId, $json);

}
echo '<pre>';print_r($response);
?>

