<?php

//用户端
Route::get('/', function () {
    return 'welcome';
});

Route::any('/test', 'Common\HomeController@test');//上传图片
Route::any('/pay', 'Common\PayController@pay');//上传图片

Route::any('/oauth2callback', 'Common\HomeController@oauth2callback');//谷歌支付验证器
Route::any('/payCallback', 'Common\HomeController@payCallback');//支付返回
Route::any('/upload/file', 'Common\UploadController@index');//上传图片
Route::any('/sms/get_sms_code', 'Common\SmsController@getSmsCode');//发送验证码
Route::any('/sms/checkSms', 'Common\SmsController@checkSms');//验证码验证
Route::any('/user/checkAccount', 'Common\UserController@checkAccount');//发送验证码
Route::any('/user/register', 'Common\UserController@register');//用户注册
Route::any('/user/fogotPass', 'Common\UserController@fogotPass');//找回密码
Route::any('/user/login', 'Common\UserController@login');//用户登录

Route::any('/home/storeList', 'Common\HomeController@storeList');//商户列表
Route::any('/home/protocol', 'Common\HomeController@protocol');//其他信息
Route::any('/home/getNearestStore', 'Common\HomeController@getNearestStore');//商户列表

Route::any('/home/getAppVersion', 'Common\HomeController@getAppVersion');// app版本


//
Route::namespace('Common')->middleware(["token"])->group(function () {

    Route::any('/user/del-user', 'UserController@delUser');//用户刪除

    Route::any('/home/index', 'HomeController@index');//首页接口
    Route::any('/home/arcicle', 'HomeController@arcicle');//文章详情
    Route::any('/home/cateList', 'HomeController@cateList');//分类列表
    Route::any('/home/shopList', 'HomeController@shopList');//商品列表
    Route::any('/home/shopDetail', 'HomeController@shopDetail');//商品详情
    Route::any('/home/recommmend', 'HomeController@recommmend');//推荐列表
    Route::any('/home/cart', 'HomeController@cart');//购物车
    Route::any('/home/addToCart', 'HomeController@addToCart');//加入购物车
    Route::any('/home/editCart', 'HomeController@editCart');//加减购物车商品
    Route::any('/home/delCart', 'HomeController@delCart');//删除购物车商品
    Route::any('/home/cartList', 'HomeController@cartList');//购物车列表
    Route::any('/home/cartSettlement', 'HomeController@cartSettlement');//购物车结算

    Route::any('/order/couposCgid', 'OrderController@couposCgid');//订单优惠券选择
    Route::any('/order/selectCoupos', 'OrderController@selectCoupos');//选择优惠券
    Route::any('/order/addOrder', 'OrderController@addOrder');//添加订单
    Route::any('/order/orderList', 'OrderController@orderList');//订单列表
    Route::any('/order/orderDetail', 'OrderController@orderDetail');//订单详情

    Route::any('/user/home', 'UserController@home');//个人中心
    Route::any('/user/isSend', 'UserController@isSend');//推播开关
    Route::any('/user/userInfo', 'UserController@userInfo');//用户信息
    Route::any('/user/editUser', 'UserController@editUser');//编辑信息
    Route::any('/user/codeMsg', 'UserController@codeMsg');//兑换码详情
    Route::any('/user/editAccount', 'UserController@editAccount');//变更手机号
    Route::any('/user/pointShop', 'UserController@pointShop');//点数商城
    Route::any('/user/coupon', 'UserController@coupon');//礼品详情
    Route::any('/user/ucmsg', 'UserController@ucmsg');//优惠券详情
    Route::any('/user/exchange', 'UserController@exchange');//兑换点数
    Route::any('/user/pointMsg', 'UserController@pointMsg');//点数兑换码列表
    Route::any('/user/userCoupon', 'UserController@userCoupon');//用户兑换码方案列表
    Route::any('/user/subscribeList', 'UserController@subscribeList');//订阅方案列表
    
    Route::any('/user/subscribeDetail', 'UserController@subscribeDetail');//订阅方案详情
    Route::any('/user/projectMsg', 'UserController@projectMsg');//方案使用记录
    Route::any('/user/projectBuy', 'UserController@projectBuy');//方案购买

    Route::any('/home/noticeList', 'HomeController@noticeList');//通知列表
    Route::any('/home/arcicleList', 'HomeController@arcicleList');//文章列表
    Route::any('/home/readNotice', 'HomeController@readNotice');//一键已读
    Route::any('/home/readarcicle', 'HomeController@readarcicle');//一键已读

    Route::any('/item/info', 'ItemController@info');//商品详情页
    Route::any('/item/getSkuInfo', 'ItemController@getSkuInfo');//商品sku详情

    Route::any('/user/Invite', 'UserController@Invite');//商品sku详情
    Route::any('/user/levelist', 'HomeController@levelist');//商品sku详情
    Route::any('/home/getforid', 'HomeController@getforid');//商品sku详情
});
