<?php
//店员端

Route::any('/shop/clerklogin', 'Shop\UserController@clerklogin');//店员登录

Route::namespace('Shop')->middleware(["shop_token"])->group(function () {

    Route::any('/shop/orderList', 'ShopController@orderList');//分销员分配商品
    Route::any('/shop/shopFinish', 'ShopController@shopFinish');//立即出餐
    Route::any('/shop/userFinish', 'ShopController@userFinish');//立即核销
    
    Route::any('/shop/getOrderFromCode', 'ShopController@getOrderFromCode');//根据核销码获取订单信息
    Route::any('/shop/getPointFromCode', 'ShopController@getPointFromCode');//根据核销码获取累积点数
    Route::any('/shop/getCouponFromStore', 'ShopController@getCouponFromStore');//根据核销码获取累积点数
    Route::any('/shop/createOrderFromProject', 'ShopController@createOrderFromProject');//核销方案码生成订单
    Route::any('/shop/writeOffCoupon', 'ShopController@writeOffCoupon');//核销优惠码
    Route::any('/shop/checkProjectList/{code}', 'ShopController@checkProjectList'); // 列出優惠券/方案可兌換的品項

    Route::any('/shop/couponList', 'UserController@couponList');//优惠券列表
});


