<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Antiddos\V20200309\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeNewL7RulesErrHealth请求参数结构体
 *
 * @method string getBusiness() 获取大禹子产品代号(bgpip表示高防IP)
 * @method void setBusiness(string $Business) 设置大禹子产品代号(bgpip表示高防IP)
 * @method array getRuleIdList() 获取规则Id列表
 * @method void setRuleIdList(array $RuleIdList) 设置规则Id列表
 */
class DescribeNewL7RulesErrHealthRequest extends AbstractModel
{
    /**
     * @var string 大禹子产品代号(bgpip表示高防IP)
     */
    public $Business;

    /**
     * @var array 规则Id列表
     */
    public $RuleIdList;

    /**
     * @param string $Business 大禹子产品代号(bgpip表示高防IP)
     * @param array $RuleIdList 规则Id列表
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Business",$param) and $param["Business"] !== null) {
            $this->Business = $param["Business"];
        }

        if (array_key_exists("RuleIdList",$param) and $param["RuleIdList"] !== null) {
            $this->RuleIdList = $param["RuleIdList"];
        }
    }
}
