<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeKBVulnerability请求参数结构体
 *
 * @method array getCVEID() 获取CVE ID列表（不能与Vul ID同时存在）
 * @method void setCVEID(array $CVEID) 设置CVE ID列表（不能与Vul ID同时存在）
 * @method array getVulID() 获取Vul ID列表（不能与CVE ID 同时存在）
 * @method void setVulID(array $VulID) 设置Vul ID列表（不能与CVE ID 同时存在）
 */
class DescribeKBVulnerabilityRequest extends AbstractModel
{
    /**
     * @var array CVE ID列表（不能与Vul ID同时存在）
     */
    public $CVEID;

    /**
     * @var array Vul ID列表（不能与CVE ID 同时存在）
     */
    public $VulID;

    /**
     * @param array $CVEID CVE ID列表（不能与Vul ID同时存在）
     * @param array $VulID Vul ID列表（不能与CVE ID 同时存在）
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("CVEID",$param) and $param["CVEID"] !== null) {
            $this->CVEID = $param["CVEID"];
        }

        if (array_key_exists("VulID",$param) and $param["VulID"] !== null) {
            $this->VulID = $param["VulID"];
        }
    }
}
