<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * MatchKBPURLList返回参数结构体
 *
 * @method array getPURLList() 获取组件列表。
 * @method void setPURLList(array $PURLList) 设置组件列表。
 * @method boolean getHit() 获取是否命中数据库。
 * @method void setHit(boolean $Hit) 设置是否命中数据库。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class MatchKBPURLListResponse extends AbstractModel
{
    /**
     * @var array 组件列表。
     */
    public $PURLList;

    /**
     * @var boolean 是否命中数据库。
     */
    public $Hit;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param array $PURLList 组件列表。
     * @param boolean $Hit 是否命中数据库。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("PURLList",$param) and $param["PURLList"] !== null) {
            $this->PURLList = [];
            foreach ($param["PURLList"] as $key => $value){
                $obj = new PURL();
                $obj->deserialize($value);
                array_push($this->PURLList, $obj);
            }
        }

        if (array_key_exists("Hit",$param) and $param["Hit"] !== null) {
            $this->Hit = $param["Hit"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
