<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cdn\V20180606\Models;
use TencentCloud\Common\AbstractModel;

/**
 * Url重定向规则配置
 *
 * @method integer getRedirectStatusCode() 获取重定向状态码，301 | 302
 * @method void setRedirectStatusCode(integer $RedirectStatusCode) 设置重定向状态码，301 | 302
 * @method string getPattern() 获取待匹配的Url，仅支持Url路径，不支持参数。默认完全匹配，支持通配符 *，最多支持5个通配符，最大长度1024字符。
 * @method void setPattern(string $Pattern) 设置待匹配的Url，仅支持Url路径，不支持参数。默认完全匹配，支持通配符 *，最多支持5个通配符，最大长度1024字符。
 * @method string getRedirectUrl() 获取目标URL，必须以“/”开头，不包含参数部分。最大长度1024字符。可使用$1, $2, $3, $4, $5分别捕获匹配路径中的通配符号，最多支持10个捕获值。
 * @method void setRedirectUrl(string $RedirectUrl) 设置目标URL，必须以“/”开头，不包含参数部分。最大长度1024字符。可使用$1, $2, $3, $4, $5分别捕获匹配路径中的通配符号，最多支持10个捕获值。
 * @method string getRedirectHost() 获取目标host，必须以http://或https://开头，并填写标准格式域名，如果不填写，默认为http:// + 当前域名
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setRedirectHost(string $RedirectHost) 设置目标host，必须以http://或https://开头，并填写标准格式域名，如果不填写，默认为http:// + 当前域名
注意：此字段可能返回 null，表示取不到有效值。
 * @method boolean getFullMatch() 获取指定是全路径配置还是任意匹配
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setFullMatch(boolean $FullMatch) 设置指定是全路径配置还是任意匹配
注意：此字段可能返回 null，表示取不到有效值。
 */
class UrlRedirectRule extends AbstractModel
{
    /**
     * @var integer 重定向状态码，301 | 302
     */
    public $RedirectStatusCode;

    /**
     * @var string 待匹配的Url，仅支持Url路径，不支持参数。默认完全匹配，支持通配符 *，最多支持5个通配符，最大长度1024字符。
     */
    public $Pattern;

    /**
     * @var string 目标URL，必须以“/”开头，不包含参数部分。最大长度1024字符。可使用$1, $2, $3, $4, $5分别捕获匹配路径中的通配符号，最多支持10个捕获值。
     */
    public $RedirectUrl;

    /**
     * @var string 目标host，必须以http://或https://开头，并填写标准格式域名，如果不填写，默认为http:// + 当前域名
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $RedirectHost;

    /**
     * @var boolean 指定是全路径配置还是任意匹配
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $FullMatch;

    /**
     * @param integer $RedirectStatusCode 重定向状态码，301 | 302
     * @param string $Pattern 待匹配的Url，仅支持Url路径，不支持参数。默认完全匹配，支持通配符 *，最多支持5个通配符，最大长度1024字符。
     * @param string $RedirectUrl 目标URL，必须以“/”开头，不包含参数部分。最大长度1024字符。可使用$1, $2, $3, $4, $5分别捕获匹配路径中的通配符号，最多支持10个捕获值。
     * @param string $RedirectHost 目标host，必须以http://或https://开头，并填写标准格式域名，如果不填写，默认为http:// + 当前域名
注意：此字段可能返回 null，表示取不到有效值。
     * @param boolean $FullMatch 指定是全路径配置还是任意匹配
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("RedirectStatusCode",$param) and $param["RedirectStatusCode"] !== null) {
            $this->RedirectStatusCode = $param["RedirectStatusCode"];
        }

        if (array_key_exists("Pattern",$param) and $param["Pattern"] !== null) {
            $this->Pattern = $param["Pattern"];
        }

        if (array_key_exists("RedirectUrl",$param) and $param["RedirectUrl"] !== null) {
            $this->RedirectUrl = $param["RedirectUrl"];
        }

        if (array_key_exists("RedirectHost",$param) and $param["RedirectHost"] !== null) {
            $this->RedirectHost = $param["RedirectHost"];
        }

        if (array_key_exists("FullMatch",$param) and $param["FullMatch"] !== null) {
            $this->FullMatch = $param["FullMatch"];
        }
    }
}
