<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * key-val类型的通用数据结构
 *
 * @method string getKey() 获取标签
 * @method void setKey(string $Key) 设置标签
 * @method integer getValue() 获取数量
 * @method void setValue(integer $Value) 设置数量
 * @method string getDesc() 获取描述信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDesc(string $Desc) 设置描述信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getNewCount() 获取今日新增数量
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setNewCount(integer $NewCount) 设置今日新增数量
注意：此字段可能返回 null，表示取不到有效值。
 */
class AssetKeyVal extends AbstractModel
{
    /**
     * @var string 标签
     */
    public $Key;

    /**
     * @var integer 数量
     */
    public $Value;

    /**
     * @var string 描述信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Desc;

    /**
     * @var integer 今日新增数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $NewCount;

    /**
     * @param string $Key 标签
     * @param integer $Value 数量
     * @param string $Desc 描述信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $NewCount 今日新增数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Key",$param) and $param["Key"] !== null) {
            $this->Key = $param["Key"];
        }

        if (array_key_exists("Value",$param) and $param["Value"] !== null) {
            $this->Value = $param["Value"];
        }

        if (array_key_exists("Desc",$param) and $param["Desc"] !== null) {
            $this->Desc = $param["Desc"];
        }

        if (array_key_exists("NewCount",$param) and $param["NewCount"] !== null) {
            $this->NewCount = $param["NewCount"];
        }
    }
}
