<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ie\V20200304\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 任务结束后生成的文件视频信息
 *
 * @method integer getStream() 获取视频流的流id。
 * @method void setStream(integer $Stream) 设置视频流的流id。
 * @method integer getWidth() 获取视频宽度。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setWidth(integer $Width) 设置视频宽度。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getHeight() 获取视频高度。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setHeight(integer $Height) 设置视频高度。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getBitrate() 获取视频码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setBitrate(integer $Bitrate) 设置视频码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getFps() 获取视频帧率，用分数格式表示，如：25/1, 99/32等等。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setFps(string $Fps) 设置视频帧率，用分数格式表示，如：25/1, 99/32等等。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getCodec() 获取编码格式，如h264,h265等等 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCodec(string $Codec) 设置编码格式，如h264,h265等等 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getRotate() 获取播放旋转角度，可选值0-360。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setRotate(integer $Rotate) 设置播放旋转角度，可选值0-360。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getDuration() 获取视频时长，单位：ms 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDuration(integer $Duration) 设置视频时长，单位：ms 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getPixFormat() 获取颜色空间，如yuv420p，yuv444p等等。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setPixFormat(string $PixFormat) 设置颜色空间，如yuv420p，yuv444p等等。
注意：此字段可能返回 null，表示取不到有效值。
 */
class VideoInfoResultItem extends AbstractModel
{
    /**
     * @var integer 视频流的流id。
     */
    public $Stream;

    /**
     * @var integer 视频宽度。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Width;

    /**
     * @var integer 视频高度。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Height;

    /**
     * @var integer 视频码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Bitrate;

    /**
     * @var string 视频帧率，用分数格式表示，如：25/1, 99/32等等。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Fps;

    /**
     * @var string 编码格式，如h264,h265等等 。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Codec;

    /**
     * @var integer 播放旋转角度，可选值0-360。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Rotate;

    /**
     * @var integer 视频时长，单位：ms 。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Duration;

    /**
     * @var string 颜色空间，如yuv420p，yuv444p等等。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $PixFormat;

    /**
     * @param integer $Stream 视频流的流id。
     * @param integer $Width 视频宽度。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Height 视频高度。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Bitrate 视频码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Fps 视频帧率，用分数格式表示，如：25/1, 99/32等等。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Codec 编码格式，如h264,h265等等 。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Rotate 播放旋转角度，可选值0-360。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Duration 视频时长，单位：ms 。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $PixFormat 颜色空间，如yuv420p，yuv444p等等。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Stream",$param) and $param["Stream"] !== null) {
            $this->Stream = $param["Stream"];
        }

        if (array_key_exists("Width",$param) and $param["Width"] !== null) {
            $this->Width = $param["Width"];
        }

        if (array_key_exists("Height",$param) and $param["Height"] !== null) {
            $this->Height = $param["Height"];
        }

        if (array_key_exists("Bitrate",$param) and $param["Bitrate"] !== null) {
            $this->Bitrate = $param["Bitrate"];
        }

        if (array_key_exists("Fps",$param) and $param["Fps"] !== null) {
            $this->Fps = $param["Fps"];
        }

        if (array_key_exists("Codec",$param) and $param["Codec"] !== null) {
            $this->Codec = $param["Codec"];
        }

        if (array_key_exists("Rotate",$param) and $param["Rotate"] !== null) {
            $this->Rotate = $param["Rotate"];
        }

        if (array_key_exists("Duration",$param) and $param["Duration"] !== null) {
            $this->Duration = $param["Duration"];
        }

        if (array_key_exists("PixFormat",$param) and $param["PixFormat"] !== null) {
            $this->PixFormat = $param["PixFormat"];
        }
    }
}
