<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Mongodb\V20190725\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 安全组信息
 *
 * @method integer getProjectId() 获取所属项目id
 * @method void setProjectId(integer $ProjectId) 设置所属项目id
 * @method string getCreateTime() 获取创建时间
 * @method void setCreateTime(string $CreateTime) 设置创建时间
 * @method array getInbound() 获取入站规则
 * @method void setInbound(array $Inbound) 设置入站规则
 * @method array getOutbound() 获取出站规则
 * @method void setOutbound(array $Outbound) 设置出站规则
 * @method string getSecurityGroupId() 获取安全组id
 * @method void setSecurityGroupId(string $SecurityGroupId) 设置安全组id
 * @method string getSecurityGroupName() 获取安全组名称
 * @method void setSecurityGroupName(string $SecurityGroupName) 设置安全组名称
 * @method string getSecurityGroupRemark() 获取安全组备注
 * @method void setSecurityGroupRemark(string $SecurityGroupRemark) 设置安全组备注
 */
class SecurityGroup extends AbstractModel
{
    /**
     * @var integer 所属项目id
     */
    public $ProjectId;

    /**
     * @var string 创建时间
     */
    public $CreateTime;

    /**
     * @var array 入站规则
     */
    public $Inbound;

    /**
     * @var array 出站规则
     */
    public $Outbound;

    /**
     * @var string 安全组id
     */
    public $SecurityGroupId;

    /**
     * @var string 安全组名称
     */
    public $SecurityGroupName;

    /**
     * @var string 安全组备注
     */
    public $SecurityGroupRemark;

    /**
     * @param integer $ProjectId 所属项目id
     * @param string $CreateTime 创建时间
     * @param array $Inbound 入站规则
     * @param array $Outbound 出站规则
     * @param string $SecurityGroupId 安全组id
     * @param string $SecurityGroupName 安全组名称
     * @param string $SecurityGroupRemark 安全组备注
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ProjectId",$param) and $param["ProjectId"] !== null) {
            $this->ProjectId = $param["ProjectId"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("Inbound",$param) and $param["Inbound"] !== null) {
            $this->Inbound = [];
            foreach ($param["Inbound"] as $key => $value){
                $obj = new SecurityGroupBound();
                $obj->deserialize($value);
                array_push($this->Inbound, $obj);
            }
        }

        if (array_key_exists("Outbound",$param) and $param["Outbound"] !== null) {
            $this->Outbound = [];
            foreach ($param["Outbound"] as $key => $value){
                $obj = new SecurityGroupBound();
                $obj->deserialize($value);
                array_push($this->Outbound, $obj);
            }
        }

        if (array_key_exists("SecurityGroupId",$param) and $param["SecurityGroupId"] !== null) {
            $this->SecurityGroupId = $param["SecurityGroupId"];
        }

        if (array_key_exists("SecurityGroupName",$param) and $param["SecurityGroupName"] !== null) {
            $this->SecurityGroupName = $param["SecurityGroupName"];
        }

        if (array_key_exists("SecurityGroupRemark",$param) and $param["SecurityGroupRemark"] !== null) {
            $this->SecurityGroupRemark = $param["SecurityGroupRemark"];
        }
    }
}
