<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tci\V20190318\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeImageTaskStatistic返回参数结构体
 *
 * @method ImageTaskStatistic getStatistic() 获取任务统计信息
 * @method void setStatistic(ImageTaskStatistic $Statistic) 设置任务统计信息
 * @method integer getJobId() 获取图像任务唯一标识符
 * @method void setJobId(integer $JobId) 设置图像任务唯一标识符
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeImageTaskStatisticResponse extends AbstractModel
{
    /**
     * @var ImageTaskStatistic 任务统计信息
     */
    public $Statistic;

    /**
     * @var integer 图像任务唯一标识符
     */
    public $JobId;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param ImageTaskStatistic $Statistic 任务统计信息
     * @param integer $JobId 图像任务唯一标识符
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Statistic",$param) and $param["Statistic"] !== null) {
            $this->Statistic = new ImageTaskStatistic();
            $this->Statistic->deserialize($param["Statistic"]);
        }

        if (array_key_exists("JobId",$param) and $param["JobId"] !== null) {
            $this->JobId = $param["JobId"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
