<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tdid\V20210519\Models;
use TencentCloud\Common\AbstractModel;

/**
 * GetPolicyList返回参数结构体
 *
 * @method array getPolicyDataList() 获取策略Policy管理列表
 * @method void setPolicyDataList(array $PolicyDataList) 设置策略Policy管理列表
 * @method integer getAllCount() 获取总数
 * @method void setAllCount(integer $AllCount) 设置总数
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class GetPolicyListResponse extends AbstractModel
{
    /**
     * @var array 策略Policy管理列表
     */
    public $PolicyDataList;

    /**
     * @var integer 总数
     */
    public $AllCount;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param array $PolicyDataList 策略Policy管理列表
     * @param integer $AllCount 总数
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("PolicyDataList",$param) and $param["PolicyDataList"] !== null) {
            $this->PolicyDataList = [];
            foreach ($param["PolicyDataList"] as $key => $value){
                $obj = new Policy();
                $obj->deserialize($value);
                array_push($this->PolicyDataList, $obj);
            }
        }

        if (array_key_exists("AllCount",$param) and $param["AllCount"] !== null) {
            $this->AllCount = $param["AllCount"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
