<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tdid\V20210519\Models;
use TencentCloud\Common\AbstractModel;

/**
 * QueryPolicy返回参数结构体
 *
 * @method integer getId() 获取披露策略索引
 * @method void setId(integer $Id) 设置披露策略索引
 * @method integer getPolicyId() 获取披露策略ID
 * @method void setPolicyId(integer $PolicyId) 设置披露策略ID
 * @method integer getCptId() 获取凭证模板ID
 * @method void setCptId(integer $CptId) 设置凭证模板ID
 * @method string getPolicyData() 获取披露策略的具体信息
 * @method void setPolicyData(string $PolicyData) 设置披露策略的具体信息
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class QueryPolicyResponse extends AbstractModel
{
    /**
     * @var integer 披露策略索引
     */
    public $Id;

    /**
     * @var integer 披露策略ID
     */
    public $PolicyId;

    /**
     * @var integer 凭证模板ID
     */
    public $CptId;

    /**
     * @var string 披露策略的具体信息
     */
    public $PolicyData;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $Id 披露策略索引
     * @param integer $PolicyId 披露策略ID
     * @param integer $CptId 凭证模板ID
     * @param string $PolicyData 披露策略的具体信息
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("PolicyId",$param) and $param["PolicyId"] !== null) {
            $this->PolicyId = $param["PolicyId"];
        }

        if (array_key_exists("CptId",$param) and $param["CptId"] !== null) {
            $this->CptId = $param["CptId"];
        }

        if (array_key_exists("PolicyData",$param) and $param["PolicyData"] !== null) {
            $this->PolicyData = $param["PolicyData"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
