<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Teo\V20220106\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 查询条件
 *
 * @method string getKey() 获取筛选条件的key。
 * @method void setKey(string $Key) 设置筛选条件的key。
 * @method string getOperator() 获取查询条件操作符，操作类型有：
<li>equals: 等于；</li>
<li>notEquals: 不等于；</li>
<li>include: 包含；</li>
<li>notInclude: 不包含; </li>
<li>startWith: 开始于；</li>
<li>notStartWith: 不开始于；</li>
<li>endWith: 结尾是；</li>
<li>notEndWith: 不结尾是。</li>
 * @method void setOperator(string $Operator) 设置查询条件操作符，操作类型有：
<li>equals: 等于；</li>
<li>notEquals: 不等于；</li>
<li>include: 包含；</li>
<li>notInclude: 不包含; </li>
<li>startWith: 开始于；</li>
<li>notStartWith: 不开始于；</li>
<li>endWith: 结尾是；</li>
<li>notEndWith: 不结尾是。</li>
 * @method array getValue() 获取筛选条件的值。
 * @method void setValue(array $Value) 设置筛选条件的值。
 */
class QueryCondition extends AbstractModel
{
    /**
     * @var string 筛选条件的key。
     */
    public $Key;

    /**
     * @var string 查询条件操作符，操作类型有：
<li>equals: 等于；</li>
<li>notEquals: 不等于；</li>
<li>include: 包含；</li>
<li>notInclude: 不包含; </li>
<li>startWith: 开始于；</li>
<li>notStartWith: 不开始于；</li>
<li>endWith: 结尾是；</li>
<li>notEndWith: 不结尾是。</li>
     */
    public $Operator;

    /**
     * @var array 筛选条件的值。
     */
    public $Value;

    /**
     * @param string $Key 筛选条件的key。
     * @param string $Operator 查询条件操作符，操作类型有：
<li>equals: 等于；</li>
<li>notEquals: 不等于；</li>
<li>include: 包含；</li>
<li>notInclude: 不包含; </li>
<li>startWith: 开始于；</li>
<li>notStartWith: 不开始于；</li>
<li>endWith: 结尾是；</li>
<li>notEndWith: 不结尾是。</li>
     * @param array $Value 筛选条件的值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Key",$param) and $param["Key"] !== null) {
            $this->Key = $param["Key"];
        }

        if (array_key_exists("Operator",$param) and $param["Operator"] !== null) {
            $this->Operator = $param["Operator"];
        }

        if (array_key_exists("Value",$param) and $param["Value"] !== null) {
            $this->Value = $param["Value"];
        }
    }
}
