<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Teo\V20220901\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeSpeedTestingMetricData返回参数结构体
 *
 * @method SpeedTestingMetricData getSpeedTestingMetricData() 获取站点拨测维度数据。
 * @method void setSpeedTestingMetricData(SpeedTestingMetricData $SpeedTestingMetricData) 设置站点拨测维度数据。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeSpeedTestingMetricDataResponse extends AbstractModel
{
    /**
     * @var SpeedTestingMetricData 站点拨测维度数据。
     */
    public $SpeedTestingMetricData;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param SpeedTestingMetricData $SpeedTestingMetricData 站点拨测维度数据。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("SpeedTestingMetricData",$param) and $param["SpeedTestingMetricData"] !== null) {
            $this->SpeedTestingMetricData = new SpeedTestingMetricData();
            $this->SpeedTestingMetricData->deserialize($param["SpeedTestingMetricData"]);
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
