<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tiia\V20190529\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DetectLabelBeta返回参数结构体
 *
 * @method array getLabels() 获取Web网络版标签结果数组。如未选择WEB场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setLabels(array $Labels) 设置Web网络版标签结果数组。如未选择WEB场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getCameraLabels() 获取Camera摄像头版标签结果数组。如未选择CAMERA场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCameraLabels(array $CameraLabels) 设置Camera摄像头版标签结果数组。如未选择CAMERA场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getAlbumLabels() 获取Album相册版标签结果数组。如未选择ALBUM场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setAlbumLabels(array $AlbumLabels) 设置Album相册版标签结果数组。如未选择ALBUM场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getNewsLabels() 获取News新闻版标签结果数组。如未选择NEWS场景，则为空。
新闻版目前为测试阶段，暂不提供每个标签的一级、二级分类信息的输出。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setNewsLabels(array $NewsLabels) 设置News新闻版标签结果数组。如未选择NEWS场景，则为空。
新闻版目前为测试阶段，暂不提供每个标签的一级、二级分类信息的输出。
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getNoneCamLabels() 获取非实拍标签
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setNoneCamLabels(array $NoneCamLabels) 设置非实拍标签
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getLocationLabels() 获取识别结果
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setLocationLabels(array $LocationLabels) 设置识别结果
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DetectLabelBetaResponse extends AbstractModel
{
    /**
     * @var array Web网络版标签结果数组。如未选择WEB场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Labels;

    /**
     * @var array Camera摄像头版标签结果数组。如未选择CAMERA场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $CameraLabels;

    /**
     * @var array Album相册版标签结果数组。如未选择ALBUM场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $AlbumLabels;

    /**
     * @var array News新闻版标签结果数组。如未选择NEWS场景，则为空。
新闻版目前为测试阶段，暂不提供每个标签的一级、二级分类信息的输出。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $NewsLabels;

    /**
     * @var array 非实拍标签
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $NoneCamLabels;

    /**
     * @var array 识别结果
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $LocationLabels;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param array $Labels Web网络版标签结果数组。如未选择WEB场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $CameraLabels Camera摄像头版标签结果数组。如未选择CAMERA场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $AlbumLabels Album相册版标签结果数组。如未选择ALBUM场景，则为空。
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $NewsLabels News新闻版标签结果数组。如未选择NEWS场景，则为空。
新闻版目前为测试阶段，暂不提供每个标签的一级、二级分类信息的输出。
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $NoneCamLabels 非实拍标签
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $LocationLabels 识别结果
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Labels",$param) and $param["Labels"] !== null) {
            $this->Labels = [];
            foreach ($param["Labels"] as $key => $value){
                $obj = new DetectLabelItem();
                $obj->deserialize($value);
                array_push($this->Labels, $obj);
            }
        }

        if (array_key_exists("CameraLabels",$param) and $param["CameraLabels"] !== null) {
            $this->CameraLabels = [];
            foreach ($param["CameraLabels"] as $key => $value){
                $obj = new DetectLabelItem();
                $obj->deserialize($value);
                array_push($this->CameraLabels, $obj);
            }
        }

        if (array_key_exists("AlbumLabels",$param) and $param["AlbumLabels"] !== null) {
            $this->AlbumLabels = [];
            foreach ($param["AlbumLabels"] as $key => $value){
                $obj = new DetectLabelItem();
                $obj->deserialize($value);
                array_push($this->AlbumLabels, $obj);
            }
        }

        if (array_key_exists("NewsLabels",$param) and $param["NewsLabels"] !== null) {
            $this->NewsLabels = [];
            foreach ($param["NewsLabels"] as $key => $value){
                $obj = new DetectLabelItem();
                $obj->deserialize($value);
                array_push($this->NewsLabels, $obj);
            }
        }

        if (array_key_exists("NoneCamLabels",$param) and $param["NoneCamLabels"] !== null) {
            $this->NoneCamLabels = [];
            foreach ($param["NoneCamLabels"] as $key => $value){
                $obj = new DetectLabelItem();
                $obj->deserialize($value);
                array_push($this->NoneCamLabels, $obj);
            }
        }

        if (array_key_exists("LocationLabels",$param) and $param["LocationLabels"] !== null) {
            $this->LocationLabels = [];
            foreach ($param["LocationLabels"] as $key => $value){
                $obj = new Product();
                $obj->deserialize($value);
                array_push($this->LocationLabels, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
