<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Vpc\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 修改VPN状态参数
 *
 * @method string getRouteId() 获取Vpn网关路由ID
 * @method void setRouteId(string $RouteId) 设置Vpn网关路由ID
 * @method string getStatus() 获取Vpn网关状态, ENABEL 启用, DISABLE禁用
 * @method void setStatus(string $Status) 设置Vpn网关状态, ENABEL 启用, DISABLE禁用
 */
class VpnGatewayRouteModify extends AbstractModel
{
    /**
     * @var string Vpn网关路由ID
     */
    public $RouteId;

    /**
     * @var string Vpn网关状态, ENABEL 启用, DISABLE禁用
     */
    public $Status;

    /**
     * @param string $RouteId Vpn网关路由ID
     * @param string $Status Vpn网关状态, ENABEL 启用, DISABLE禁用
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("RouteId",$param) and $param["RouteId"] !== null) {
            $this->RouteId = $param["RouteId"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }
    }
}
