<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Waf\V20180125\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyAccessPeriod请求参数结构体
 *
 * @method integer getPeriod() 获取访问日志保存期限，范围为[1, 30]
 * @method void setPeriod(integer $Period) 设置访问日志保存期限，范围为[1, 30]
 * @method string getTopicId() 获取日志主题
 * @method void setTopicId(string $TopicId) 设置日志主题
 */
class ModifyAccessPeriodRequest extends AbstractModel
{
    /**
     * @var integer 访问日志保存期限，范围为[1, 30]
     */
    public $Period;

    /**
     * @var string 日志主题
     */
    public $TopicId;

    /**
     * @param integer $Period 访问日志保存期限，范围为[1, 30]
     * @param string $TopicId 日志主题
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Period",$param) and $param["Period"] !== null) {
            $this->Period = $param["Period"];
        }

        if (array_key_exists("TopicId",$param) and $param["TopicId"] !== null) {
            $this->TopicId = $param["TopicId"];
        }
    }
}
