<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Booking;

class CancleBooking extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'booking:cancle';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $startDate = Carbon::now()->subDays(3)->startOfDay();
        $endDate = Carbon::now()->subDay(3)->endOfDay();
        $bookings = Booking::where('status', 'pending')->whereBetween('created_at', [$startDate, $endDate])->get();

        foreach($bookings as $booking){
            $booking->status = 'cancle';
            $booking->save();
        }
    }
}
