<?php

namespace App\DataTables;
use App\Traits\DataTableTrait;

use App\Models\ProviderType;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class ProviderTypeDataTable extends DataTable
{
    use DataTableTrait;
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $query->orderBy( 'created_at', 'desc' );
        return datatables()
            ->eloquent($query)
            ->editColumn('status' , function ($providertype){
                return '<div class="custom-control custom-switch custom-switch-text custom-switch-color custom-control-inline">
                    <div class="custom-switch-inner">
                        <input type="checkbox" class="custom-control-input bg-success change_status" data-type="providertype_status" '.($providertype->status ? "checked" : "").' value="'.$providertype->id.'" id="'.$providertype->id.'" data-id="'.$providertype->id.'">
                        <label class="custom-control-label" for="'.$providertype->id.'" data-on-label="" data-off-label=""></label>
                    </div>
                </div>';
            })
            ->editColumn('type' , function ($providertype){
                return __('messages.'.$providertype->type);
            })
            ->addColumn('action', function($providertype){
                return view('providertype.action',compact('providertype'))->render();
            })
            ->addIndexColumn()
            ->rawColumns(['action','status']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\ProviderType $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(ProviderType $model)
    {
        if(auth()->user()->hasAnyRole(['admin'])){
            $model = $model->withTrashed();
        }
        return $model->newQuery();
    }
   
    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            Column::make('DT_RowIndex')
                  ->searchable(false)
                  ->title(__('messages.srno'))
                  ->orderable(false),
            Column::make('name')
                ->title(__('messages.first_name')),
            Column::make('commission')
                ->title(__('messages.commission')),
            Column::make('type')
                ->title(__('messages.type')),
            Column::computed('action')
                ->title(__('messages.action'))
                ->exportable(false)
                ->printable(false)
                ->width(60)
                ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'ProviderType_' . date('YmdHis');
    }
}
