<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Announcement;
use App\Http\Resources\API\AnnouncementResource;


class AnnouncementController extends Controller

{
    public function getAnnouncementList(Request $request){  
        $announcement = Announcement::orderBy('id','desc');
        if(!empty($request->provider_id)){
            $announcement = $announcement->where('author_id',$request->provider_id);
        }
        if(!empty($request->status)){
            $announcement = $announcement->where('status',$request->status);
        }
        $auth_user = auth()->user();
        if(auth()->user() !== null){
            if(auth()->user()->hasRole('admin')){
                $announcement = new Announcement();
                $announcement = $announcement->withTrashed();
            }
        }
        if($request->has('is_featured')){
            $announcement->where('is_featured',$request->is_featured);
        }

        $per_page = config('constant.PER_PAGE_LIMIT');
        if( $request->has('per_page') && !empty($request->per_page)){
            if(is_numeric($request->per_page)){
                $per_page = $request->per_page;
            }
            if($request->per_page === 'all' ){
                $per_page = $announcement->count();
            }
        }

        $announcement = $announcement->paginate($per_page);
        $items = AnnouncementResource::collection($announcement);

        $response = [
            'pagination' => [
                'total_items' => $items->total(),
                'per_page' => $items->perPage(),
                'currentPage' => $items->currentPage(),
                'totalPages' => $items->lastPage(),
                'from' => $items->firstItem(),
                'to' => $items->lastItem(),
                'next_page' => $items->nextPageUrl(),
                'previous_page' => $items->previousPageUrl(),
            ],
            'data' => $items,
        ];

        
        return comman_custom_response($response);
    }
    public function getAnnouncementDetail(Request $request){
        $id = $request->announcement_id;
        $customer_id = $request->customer_id;
       
        if(auth()->user() !== null){
            if(auth()->user()->hasRole('admin')){
                $announcement = Announcement::withTrashed()->findorfail($id);
            }
            else{
                $announcement = Announcement::findorfail($id);
            }
        }else{
            $announcement = Announcement::findorfail($id);
        }
        if(empty($announcement)){
            $message = __('messages.record_not_found');
            return comman_message_response($message,400);
        }
        if($customer_id !== $announcement->author_id){
            $announcement->total_views = $announcement->total_views + 1;
            $announcement->update();
        }
        $announcement_detail = new AnnouncementResource($announcement);

        $response = [
            'announcement_detail' => $announcement_detail
        ];


        return comman_custom_response($response);
    }

    public function getAnnouncementSpecial(Request $request){  
        $announcement = Announcement::orderBy('id','desc');
        if(!empty($request->provider_id)){
            $announcement = $announcement->where('author_id',$request->provider_id);
        }
        if(!empty($request->status)){
            $announcement = $announcement->where('status',$request->status);
        }
        $auth_user = auth()->user();
        if(auth()->user() !== null){
            if(auth()->user()->hasRole('admin')){
                $announcement = new Announcement();
                $announcement = $announcement->withTrashed();
            }
        }
        if($request->has('is_featured')){
            $announcement->where('is_featured',$request->is_featured);
        }

        $per_page = config('constant.PER_PAGE_LIMIT');
        if( $request->has('per_page') && !empty($request->per_page)){
            if(is_numeric($request->per_page)){
                $per_page = $request->per_page;
            }
            if($request->per_page === 'all' ){
                $per_page = $announcement->count();
            }
        }

        $announcement = $announcement->paginate($per_page);
        $items = AnnouncementResource::collection($announcement);

        $response = [
            'pagination' => [
                'total_items' => $items->total(),
                'per_page' => $items->perPage(),
                'currentPage' => $items->currentPage(),
                'totalPages' => $items->lastPage(),
                'from' => $items->firstItem(),
                'to' => $items->lastItem(),
                'next_page' => $items->nextPageUrl(),
                'previous_page' => $items->previousPageUrl(),
            ],
            'data' => $items,
        ];

        
        return comman_custom_response($response);
    }

}