<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;

class BannerController extends Controller
{
    public function getBanner(Request $request)
    {
        $response = [];

        $bannerData = Banner::where('type',$request->type)->first();
        if($bannerData){
            $attchments = $bannerData->getMedia('banner_attachment');
            $file_extention = config('constant.IMAGE_EXTENTIONS');
            foreach( $attchments as $attchment ){
                $extention = in_array(strtolower(imageExtention($attchment->getFullUrl())), $file_extention);
                if($extention){
                    $response[] = $attchment->getFullUrl();
                }
            }
        }
        return comman_custom_response($response);
        
    }
}
