<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Config;

class CountryController extends Controller
{
    public function getCountryData()
    {
        $country = Config::get('country');
        $countryData = [
            'city' => $country['city'],
            'districts' => $country['districts']
        ];

        return comman_custom_response($countryData);
    }

    public function getDistrictsData(Request $request)
    {
        $city = $request->city;

        $country = Config::get('country');

        $districts = $country['districts'][$city];

        return comman_custom_response($districts);
    }
}