<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payment;
use App\Models\Booking;
use App\Http\Resources\API\PaymentResource;
use Braintree;
use App\Models\User;
use App\Http\Controllers\LineNotifyController;


class PaymentController extends Controller
{
    public function savePayment(Request $request)
    {
        $data = $request->all();
        $data['datetime'] = isset($request->datetime) ? date('Y-m-d H:i:s',strtotime($request->datetime)) : date('Y-m-d H:i:s');
        $result = Payment::create($data);
        $booking = Booking::find($request->booking_id);
        $booking->payment_id = $result->id;
        $booking->total_amount = $result->total_amount;
        $booking->save();
        $status_code = 200;
        if($result->payment_status == 'paid'){
            $message = __('messages.payment_completed');
        } else {
            $message = __('messages.payment_message',['status' => __('messages.'.$result->payment_status) ]);
        }

        if($result->payment_status == 'failed')
        {
            $status_code = 400;
        }
        return comman_message_response($message,$status_code);
    }

    public function saveRemitCode(Request $request)
    {
        $data = $request->all();
        $data['datetime'] = isset($request->datetime) ? date('Y-m-d H:i:s',strtotime($request->datetime)) : date('Y-m-d H:i:s');

        $bookingdata = Booking::find($request->booking_id);
        Payment::where('booking_id', $request->booking_id)->delete();

        // if(Payment::isNewebPay()){
        //     $data['payment_type'] = 'credit';

        // }else{
            $data['payment_type'] = 'atm';
            $data['remit_code'] = $data['remitCode'];

        // }

        $data['total_amount'] = $bookingdata->total_amount;
        $data['discount'] = $bookingdata->discount;

        $result = Payment::create($data);

        $bookingdata->update([
            'payment_id' => $result->id,
            'status' => 'in_progress'
        ]);
        // 通知
        $this->sendLineMsg($bookingdata);

        $message = __('messages.save_form',[ 'form' => __('通知匯款資料') ] );

        return comman_message_response($message);
    }

    public function updateRemitCode(Request $request)
    {
        $data = $request->all();

        $paymentdata = Booking::find($request->booking_id)->payment;
        $paymentdata->update([
            'remit_code' => $data['remitCode']
        ]);

        $message = __('messages.save_form',[ 'form' => __('通知匯款資料') ] );

        return comman_message_response($message);
    }

    public function paymentList(Request $request)
    {
        $payment = Payment::myPayment()->with('booking');

        $per_page = config('constant.PER_PAGE_LIMIT');
        if( $request->has('per_page') && !empty($request->per_page)){
            if(is_numeric($request->per_page)){
                $per_page = $request->per_page;
            }
            if($request->per_page === 'all' ){
                $per_page = $payment->count();
            }
        }

        $payment = $payment->orderBy('id','desc')->paginate($per_page);
        $items = PaymentResource::collection($payment);

        $response = [
            'pagination' => [
                'total_items' => $items->total(),
                'per_page' => $items->perPage(),
                'currentPage' => $items->currentPage(),
                'totalPages' => $items->lastPage(),
                'from' => $items->firstItem(),
                'to' => $items->lastItem(),
                'next_page' => $items->nextPageUrl(),
                'previous_page' => $items->previousPageUrl(),
            ],
            'data' => $items,
        ];
        
        return comman_custom_response($response);
    }

    protected function sendLineMsg($booking){
        $userText = '【付款完成通知】 訂單 編號'.$booking->id."\n"
        .'您好我們是家顧者照護媒合平台，已收到您完成轉帳付款通知，平台將會核對金額，如無誤後續將有服務人員提供您的委託服務。';
        LineNotifyController::send( $booking->customer, $userText );

        $adminText = '【已完成付款通知】 訂單 編號'.$booking->id
        .'您好我們是家顧者照護媒合平台：已收到消費者完成轉帳付款通知，平台將會核對金額，如無誤後續將請您進行後續的委託服務。';
        LineNotifyController::send( $booking->provider, $adminText );

        // 通知所有管理員
        $admins = User::where('user_type', 'admin')->get();
        foreach ($admins as $admin) {
            LineNotifyController::send( $admin, $adminText );
        }
    }

}