<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Announcement;
use App\DataTables\AnnouncementDataTable;
use App\Models\Banner;

class AnnouncementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(AnnouncementDataTable $dataTable)
    {
        $pageTitle = trans('messages.list_form_title',['form' => trans('messages.announcement')] );
        $auth_user = authSession();
        $assets = ['datatable'];
        return $dataTable->render('announcement.index', compact('pageTitle','auth_user','assets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $id = $request->id;
        $auth_user = authSession();

        $announcementdata = Announcement::find($id);
        $pageTitle = trans('messages.update_form_title',['form'=>trans('messages.announcement')]);
        
        if($announcementdata == null){
            $pageTitle = trans('messages.add_button_form',['form' => trans('messages.announcement')]);
            $announcementdata = new Announcement;
        }
        
        return view('announcement.create', compact('pageTitle' ,'announcementdata' ,'auth_user' ));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $data = $request->all();
        $data['author_id'] = !empty($request->author_id) ? $request->author_id : auth()->user()->id;
        $data['is_featured'] = 0;
        if($request->has('is_featured')){
			$data['is_featured'] = 1;
		}
        $result = Announcement::updateOrCreate(['id' => $data['id'] ],$data);

        if($request->is('api/*')){
			if($request->has('attachment_count')) {
				for($i = 0 ; $i < $request->attachment_count ; $i++){
					$attachment = "announcement_attachment_".$i;
					if($request->$attachment != null){
						$file[] = $request->$attachment;
					}
				}
				storeMediaFile($result,$file, 'announcement_attachment');
			}
		}else{
			storeMediaFile($result,$request->announcement_attachment, 'announcement_attachment');
		}

        $message = trans('messages.update_form',['form' => trans('messages.announcement')]);
        if($result->wasRecentlyCreated){
            $message = trans('messages.save_form',['form' => trans('messages.announcement')]);
        }
        if($request->is('api/*')) {
            return comman_message_response($message);
		}
        return redirect(route('announcement.index'))->withSuccess($message);        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $announcement = Announcement::find($id);
        $msg= __('messages.msg_fail_to_delete',['name' => __('messages.announcement')] );
        
        if($announcement!='') { 

            $announcement->delete();
            $msg= __('messages.msg_deleted',['name' => __('messages.announcement')] );
        }
        if(request()->is('api/*')) {
            return comman_message_response($msg);
		}
        return redirect()->back()->withSuccess($msg);
    }   
    public function action(Request $request){
        $id = $request->id;

        $announcement  = Announcement::withTrashed()->where('id',$id)->first();
        $msg = __('messages.not_found_entry',['name' => __('messages.announcement')] );
        if($request->type == 'restore') {
            $announcement->restore();
            $msg = __('messages.msg_restored',['name' => __('messages.announcement')] );
        }
        if($request->type === 'forcedelete'){
            $announcement->forceDelete();
            $msg = __('messages.msg_forcedelete',['name' => __('messages.announcement')] );
        }
        if(request()->is('api/*')){
            return comman_message_response($msg);
		}
        return comman_custom_response(['message'=> $msg , 'status' => true]);
    }

    public function banner(Request $request)
    {
        $auth_user = authSession();
        $img = '';
        $bannerdata = Banner::where('type', 'announcement')->first();
        if($bannerdata == null){
            $bannerdata = new Banner;
        }
        $pageTitle = trans('messages.announcement') . ' Banner 設定';
        return view('announcement.banner', compact('img' ,'auth_user', 'bannerdata', 'pageTitle' ));
    }

    public function bannerUpdate(Request $request)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $data = $request->all();
        $result = Banner::updateOrCreate(['id' => $data['id'], 'type' => 'announcement'], $data);

        storeMediaFile($result,$request->banner_attachment, 'banner_attachment');

        $message = trans('messages.update_form',['form' => trans('messages.announcement')]);
        if($result->wasRecentlyCreated){
            $message = trans('messages.save_form',['form' => trans('messages.announcement')]);
        }
        
        return redirect(route('announcement.index'))->withSuccess($message);
    }
    
}
