<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Gcreate\LineNotify\Controllers\LineNotify;
use App\Models\User;

class LineNotifyController extends Controller
{
    public function send( $user = null, $text='', $args=[]) {

        if( !$user ){
            $user = Auth::user();
        }
        
        if ( empty($user->line_notify_access_token) ) return __( '未綁定' );

        if ( empty($text) ) return __( '寫入文字');

		if( !LineNotify::check_token($user->line_notify_access_token) ){
			$user->line_notify_access_token = '';
			$user->save();
			return __( '未綁定');
		}

        $result = LineNotify::send($user,$text);

    }

    public function lineAuthorize(Request $request){

        $redirectUrl = LineNotify::bindLineUrl(Auth::user());

        return redirect($redirectUrl);
    }

    public function callback(Request $request){

        $user = User::where( 'line_notify_state', $request->state)->first();

        $callbackStatus = LineNotify::callback($request, $user);

        $result = $this->send( $user, '家顧者綁定成功');

        $message = '連動失敗';
        $status = 'fail';

        if($callbackStatus){
            $message = '連動成功';
            $status = 'success';
        }
        return redirect('/')->with( $status, $message );
    }

    public function removeLineNotify(Request $request)
    {
        $result = LineNotify::revoke(Auth::user());

        if($result){
            return redirect()->back()->with('fail', '解除連動成功');
        }else{
            return redirect()->back()->with('fail', '解除連動失敗');
        }
    }
    
}
