<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Ycs77\NewebPay\Facades\NewebPay;
use App\Models\Booking;
use App\Models\Payment;
use App\Models\User;
use Carbon\Carbon;
use App\Http\Controllers\LineNotifyController;

class NewebPayController extends Controller
{
    const PAYMENT_TYPE = [
        'atm',
        'credit'
    ];
    
    function payment(Request $request)
    {
        $booking = Booking::find($request->booking_id);
        $result = $this->savePayment($booking);

        $no = $result->id;                          // 訂單編號
        $amt = $result->total_amount;               // 交易金額
        $desc = $result->booking->service->name;    // 商品名稱
        $email = ''; // 付款人信箱

        return NewebPay::payment($no, $amt, $desc, $email)->submit();
    }

    public function savePayment($booking)
    {
        $data = [
            'customer_id' => $booking->customer_id,
            'booking_id' => $booking->id,
            'discount' => $booking->discount??null,
            'total_amount' => $booking->total_amount,
            'payment_status' => 'pending',
            // payment_type 要換成 atm 或 credit
            'payment_type' => 'pending',
        ];

        $result = Payment::create($data);

        return $result;
    }


    function callback(Request $request)
    {
        $data = NewebPay::decodeFromRequest();
        $result = collect($data['Result']);
        $payment = Payment::find($result['MerchantOrderNo']);
        $booking = Booking::find($payment->booking_id);
        $user = User::find($booking->customer_id);
        /*
         * txn_id => 信用卡回傳的交易編號
         * datetime = > 交易的時間
         * */
        $payment->txn_id = $result['TradeNo'];
        $payment->datetime = Carbon::now();
        $payment->other_transaction_detail = $result;

        $booking->payment_id = $payment->id;

        if($data['Status'] === 'SUCCESS'){
            $payment->payment_status = 'paid';
            $payment->payment_type = 'paid';
            if($user->line_notify_access_token){
                $userText ='您預約'.$booking->service->name."\n時間：".$booking->date."\n金額：".$booking->total_amount.'元\n付款成功';
            }
        }else{
            $payment->payment_status = 'failed';
            $payment->payment_type = 'failed';
            if($user->line_notify_access_token){
                $userText ='您預約'.$booking->service->name."\n時間：".$booking->date."\n金額：".$booking->total_amount.'元\n授權錯誤請聯絡管理員';
            }
        }
        $payment->save();
        $booking->save();
        if($user->line_notify_access_token){
            LineNotifyController::send( $user, $userText );
        }

        return redirect( url('/') );
    }

    function notify(Request $request)
    {
        $data = NewebPay::decodeFromRequest();
        dd($data);
        // 儲存資料 和 發送付款成功通知...
    }

    // 信用卡取消授權
    function creditCancel()
    {
        return NewebPay::creditCancel(
            no, // 該筆交易的訂單編號
            amt,  // 該筆交易的金額
            'order' // 可選擇是由 `order`->訂單編號，或是 `trade`->藍新交易編號來做申請
        )->submit();
    }
    // 信用卡請款
    function requestPayment()
    {
        return NewebPay::requestPayment(
            no, // 該筆交易的訂單編號
            amt,  // 該筆交易的金額
            'order' // 可選擇是由 `order`->訂單編號，或是 `trade`->藍新交易編號來做申請
        )->submit();
    }
    // 信用卡退款
    function requestRefund()
    {
        return NewebPay::requestRefund(
            no, // 該筆交易的訂單編號
            amt,  // 該筆交易的金額
            'order' // 可選擇是由 `order`->訂單編號，或是 `trade`->藍新交易編號來做申請
        )->submit();
    }
}
