<?php

namespace App\Http\Controllers;

use App\Models\Question;
use Illuminate\Http\Request;
use App\DataTables\QuestionDataTable;
use App\Http\Requests\QuestionRequest;
use App\Models\Banner;

class QuestionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(QuestionDataTable $dataTable)
    {
        $pageTitle = trans('messages.list_form_title',['form' => trans('messages.question')] );
        $auth_user = authSession();
        $assets = ['datatable'];
        return $dataTable->render('question.index', compact('pageTitle','auth_user','assets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $id = $request->id;
        $auth_user = authSession();

        $questionData = Question::find($id);
        $pageTitle = trans('messages.update_form_title',['form'=>trans('messages.question')]);
        
        if($questionData == null){
            $pageTitle = trans('messages.add_button_form',['form' => trans('messages.question')]);
            $questionData = new Question;
        }
        
        return view('question.create', compact('pageTitle' ,'questionData' ,'auth_user' ));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $data = $request->all();
        $data['author_id'] = !empty($request->author_id) ? $request->author_id : auth()->user()->id;
        $data['is_featured'] = 0;
        if($request->has('is_featured')){
            $data['is_featured'] = 1;
        }
        $result = Question::updateOrCreate(['id' => $data['id'] ],$data);

        if($request->is('api/*')){
            if($request->has('attachment_count')) {
                for($i = 0 ; $i < $request->attachment_count ; $i++){
                    $attachment = "question_attachment_".$i;
                    if($request->$attachment != null){
                        $file[] = $request->$attachment;
                    }
                }
                storeMediaFile($result,$file, 'question_attachment');
            }
        }else{
            storeMediaFile($result,$request->question_attachment, 'question_attachment');
        }

        $message = trans('messages.update_form',['form' => trans('messages.question')]);
        if($result->wasRecentlyCreated){
            $message = trans('messages.save_form',['form' => trans('messages.question')]);
        }
        if($request->is('api/*')) {
            return comman_message_response($message);
        }
        return redirect(route('question.index'))->withSuccess($message);        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function show(Question $question)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function edit(Question $question)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Question $question)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $question = Question::find($id);
        $msg= __('messages.msg_fail_to_delete',['name' => __('messages.question')] );
        
        if($question!='') { 

            $question->delete();
            $msg= __('messages.msg_deleted',['name' => __('messages.question')] );
        }
        if(request()->is('api/*')) {
            return comman_message_response($msg);
		}
        return redirect()->back()->withSuccess($msg);
    }

    public function action(Request $request){
        $id = $request->id;

        $question  = Question::withTrashed()->where('id',$id)->first();
        $msg = __('messages.not_found_entry',['name' => __('messages.question')] );
        if($request->type == 'restore') {
            $question->restore();
            $msg = __('messages.msg_restored',['name' => __('messages.question')] );
        }
        if($request->type === 'forcedelete'){
            $question->forceDelete();
            $msg = __('messages.msg_forcedelete',['name' => __('messages.question')] );
        }
        if(request()->is('api/*')){
            return comman_message_response($msg);
		}
        return comman_custom_response(['message'=> $msg , 'status' => true]);
    }

    public function banner(Request $request)
    {
        $auth_user = authSession();
        $img = '';
        $bannerdata = Banner::where('type', 'question')->first();
        if($bannerdata == null){
            $bannerdata = new Banner;
        }
        $pageTitle = trans('messages.question') . ' Banner 設定';
        return view('question.banner', compact('img' ,'auth_user', 'bannerdata', 'pageTitle' ));
    }

    public function bannerUpdate(Request $request)
    {
        if(demoUserPermission()){
            return  redirect()->back()->withErrors(trans('messages.demo_permission_denied'));
        }
        $data = $request->all();
        $result = Banner::updateOrCreate(['id' => $data['id'], 'type' => 'question'], $data);

        storeMediaFile($result,$request->banner_attachment, 'banner_attachment');

        $message = trans('messages.update_form',['form' => trans('messages.question')]);
        if($result->wasRecentlyCreated){
            $message = trans('messages.save_form',['form' => trans('messages.question')]);
        }
        
        return redirect(route('question.index'))->withSuccess($message);
    }
}
