<?php
namespace App\Services;

Class SmsService
{

    private $gcUrl,$username,$password;

    public function __construct()
    {
		$this->gcUrl = 'https://smsb2c.mitake.com.tw/b2c/mtk/';
		$this->username = '54806334';
		$this->password = 'ganes0503';
    }

    public function doRequest($method, $uri, $data = [])
    {
    	$body = $this->arrayToIniString( $data );

	    $result = $this->mitakeCurl($method, $uri, $body);

	    return $result;
    }

	public function __call($method, $args)
    {
        array_unshift($args, $method);

        return call_user_func_array([$this, 'doRequest'], $args);
    }

    public function getBalance()
    {
        $response = $this->post('SmQuery');
		$response = preg_replace("/[\s]{2,}/","&",$response);
        if ($response) {
            parse_str($response, $arr);
			$account_point = isset( $arr['AccountPoint'] ) ? $arr['AccountPoint'] : false;
			if( ! $account_point ){
				$account_point = isset( $arr['Error'] ) ? $arr['Error'] : '無法取得餘額';
			}
            return $account_point;
        }

        return 0;
    }

    public function send($data = [])
    {
		foreach( $data as $index => $row ){
			$data[$index]['smbody'] = str_replace(["\r\n", "\n\r", "\r", "\n"], chr(6), $data[$index]['smbody']);
		}
		
        $response = $this->post('SmBulkSend', $data);

        return $response;
    }

	protected function arrayToIniString($a = [], $parent = [])
    {
        $out = '';

		$default = [
			'ClientID' => '',
			'dstaddr'  => '',
			'dlvtime'  => '',
			'vldtime'  => '',
			'destname' => '',
			'response' => '',
			'smbody'   => ''
		];
		
		foreach( $a as $k => $v ){
			$default['ClientID'] = rand(0,99999999);
			$v = array_merge( $default, $v );
			$out .= implode( '$$', $v ) . PHP_EOL;
		}

        return mb_convert_encoding( $out, 'big5' );
    }

    public function mitakeCurl($method, $uri, $body){
		// return true;
		$url = $this->gcUrl . $uri . '?username=' . $this->username . '&password=' . $this->password;
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
	    curl_setopt($ch, CURLOPT_HEADER, 0);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
	    curl_setopt($ch, CURLOPT_POST, TRUE);
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	    $result = curl_exec($ch);
	    curl_close($ch);
	    return $result;
	}


}