<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddGenderColumnAndOtherToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('gender')->default(0);
            $table->json('service')->nullable();
            $table->json('serviceItem')->nullable();
            $table->json('role1')->nullable();
            $table->json('role2')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('gender');
            $table->dropColumn('service');
            $table->dropColumn('serviceItem');
            $table->dropColumn('role1');
            $table->dropColumn('role2');
        });
    }
}
