<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddBankInfoToAppSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('app_settings', function (Blueprint $table) {
            $table->boolean('neweb_status')->default(false);
            $table->string('bank_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->string('bank_code')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_name')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('app_settings', function (Blueprint $table) {
            $table->dropColumn('neweb_status');
            $table->dropColumn('bank_name');
            $table->dropColumn('branch_name');
            $table->dropColumn('bank_code');
            $table->dropColumn('account_number');
            $table->dropColumn('account_name');
        });
    }
}
