import { __spreadArrays } from "tslib";
import $debounce from 'lodash-es/debounce';
export function debounce() {
    var options = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        options[_i] = arguments[_i];
    }
    return function (_proto, key, descriptor) {
        var fn = descriptor.value;
        return {
            get: function () {
                if (!this.hasOwnProperty(key)) {
                    Object.defineProperty(this, key, {
                        value: $debounce.apply(void 0, __spreadArrays([fn], options)),
                    });
                }
                return this[key];
            },
        };
    };
}
//# sourceMappingURL=debounce.js.map