import { eventScope, } from '../utils/';
var KEY_CODE;
(function (KEY_CODE) {
    KEY_CODE[KEY_CODE["TAB"] = 9] = "TAB";
    KEY_CODE[KEY_CODE["SPACE"] = 32] = "SPACE";
    KEY_CODE[KEY_CODE["PAGE_UP"] = 33] = "PAGE_UP";
    KEY_CODE[KEY_CODE["PAGE_DOWN"] = 34] = "PAGE_DOWN";
    KEY_CODE[KEY_CODE["END"] = 35] = "END";
    KEY_CODE[KEY_CODE["HOME"] = 36] = "HOME";
    KEY_CODE[KEY_CODE["LEFT"] = 37] = "LEFT";
    KEY_CODE[KEY_CODE["UP"] = 38] = "UP";
    KEY_CODE[KEY_CODE["RIGHT"] = 39] = "RIGHT";
    KEY_CODE[KEY_CODE["DOWN"] = 40] = "DOWN";
})(KEY_CODE || (KEY_CODE = {}));
export function keyboardHandler(scrollbar) {
    var addEvent = eventScope(scrollbar);
    var container = scrollbar.containerEl;
    addEvent(container, 'keydown', function (evt) {
        var activeElement = document.activeElement;
        if (activeElement !== container && !container.contains(activeElement)) {
            return;
        }
        if (isEditable(activeElement)) {
            return;
        }
        var delta = getKeyDelta(scrollbar, evt.keyCode || evt.which);
        if (!delta) {
            return;
        }
        var x = delta[0], y = delta[1];
        scrollbar.addTransformableMomentum(x, y, evt, function (willScroll) {
            if (willScroll) {
                evt.preventDefault();
            }
            else {
                scrollbar.containerEl.blur();
                if (scrollbar.parent) {
                    scrollbar.parent.containerEl.focus();
                }
            }
        });
    });
}
function getKeyDelta(scrollbar, keyCode) {
    var size = scrollbar.size, limit = scrollbar.limit, offset = scrollbar.offset;
    switch (keyCode) {
        case KEY_CODE.TAB:
            return handleTabKey(scrollbar);
        case KEY_CODE.SPACE:
            return [0, 200];
        case KEY_CODE.PAGE_UP:
            return [0, -size.container.height + 40];
        case KEY_CODE.PAGE_DOWN:
            return [0, size.container.height - 40];
        case KEY_CODE.END:
            return [0, limit.y - offset.y];
        case KEY_CODE.HOME:
            return [0, -offset.y];
        case KEY_CODE.LEFT:
            return [-40, 0];
        case KEY_CODE.UP:
            return [0, -40];
        case KEY_CODE.RIGHT:
            return [40, 0];
        case KEY_CODE.DOWN:
            return [0, 40];
        default:
            return null;
    }
}
function handleTabKey(scrollbar) {
    // handle in next frame
    requestAnimationFrame(function () {
        scrollbar.scrollIntoView(document.activeElement, {
            offsetTop: scrollbar.size.container.height / 2,
            onlyScrollIfNeeded: true,
        });
    });
}
function isEditable(elem) {
    if (elem.tagName === 'INPUT' ||
        elem.tagName === 'SELECT' ||
        elem.tagName === 'TEXTAREA' ||
        elem.isContentEditable) {
        return !elem.disabled;
    }
    return false;
}
//# sourceMappingURL=keyboard.js.map