import { __decorate } from "tslib";
import { ScrollbarTrack } from './track';
import { TrackDirection } from './direction';
import { debounce, } from '../decorators/';
var TrackController = /** @class */ (function () {
    function TrackController(_scrollbar) {
        this._scrollbar = _scrollbar;
        var thumbMinSize = _scrollbar.options.thumbMinSize;
        this.xAxis = new ScrollbarTrack(TrackDirection.X, thumbMinSize);
        this.yAxis = new ScrollbarTrack(TrackDirection.Y, thumbMinSize);
        this.xAxis.attachTo(_scrollbar.containerEl);
        this.yAxis.attachTo(_scrollbar.containerEl);
        if (_scrollbar.options.alwaysShowTracks) {
            this.xAxis.show();
            this.yAxis.show();
        }
    }
    /**
     * Updates track appearance
     */
    TrackController.prototype.update = function () {
        var _a = this._scrollbar, size = _a.size, offset = _a.offset;
        this.xAxis.update(offset.x, size.container.width, size.content.width);
        this.yAxis.update(offset.y, size.container.height, size.content.height);
    };
    /**
     * Automatically hide tracks when scrollbar is in idle state
     */
    TrackController.prototype.autoHideOnIdle = function () {
        if (this._scrollbar.options.alwaysShowTracks) {
            return;
        }
        this.xAxis.hide();
        this.yAxis.hide();
    };
    __decorate([
        debounce(300)
    ], TrackController.prototype, "autoHideOnIdle", null);
    return TrackController;
}());
export { TrackController };
//# sourceMappingURL=index.js.map