var eventListenerOptions;
var eventMap = new WeakMap();
function getOptions() {
    if (eventListenerOptions !== undefined) {
        return eventListenerOptions;
    }
    var supportPassiveEvent = false;
    try {
        var noop = function () { };
        var options = Object.defineProperty({}, 'passive', {
            get: function () {
                supportPassiveEvent = true;
            },
        });
        window.addEventListener('testPassive', noop, options);
        window.removeEventListener('testPassive', noop, options);
    }
    catch (e) { }
    eventListenerOptions = supportPassiveEvent ? { passive: false } : false;
    return eventListenerOptions;
}
export function eventScope(scrollbar) {
    var configs = eventMap.get(scrollbar) || [];
    eventMap.set(scrollbar, configs);
    return function addEvent(elem, events, fn) {
        function handler(event) {
            // ignore default prevented events
            if (event.defaultPrevented) {
                return;
            }
            fn(event);
        }
        events.split(/\s+/g).forEach(function (eventName) {
            configs.push({ elem: elem, eventName: eventName, handler: handler });
            elem.addEventListener(eventName, handler, getOptions());
        });
    };
}
export function clearEventsOn(scrollbar) {
    var configs = eventMap.get(scrollbar);
    if (!configs) {
        return;
    }
    configs.forEach(function (_a) {
        var elem = _a.elem, eventName = _a.eventName, handler = _a.handler;
        elem.removeEventListener(eventName, handler, getOptions());
    });
    eventMap.delete(scrollbar);
}
//# sourceMappingURL=event-hub.js.map