# vue-core-video-player

[![CircleCI](https://circleci.com/gh/core-player/vue-core-video-player.svg?style=shield)](https://circleci.com/gh/core-player/vue-core-video-player)
[![prs welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/core-player/vue-core-video-player/pulls)
[![npm version](https://img.shields.io/npm/v/vue-core-video-player.svg?style=flat-square)](https://www.npmjs.com/package/vue-core-video-player)
[![npm downloads](https://img.shields.io/npm/dm/vue-core-video-player.svg?style=flat-square)](https://www.npmjs.com/package/vue-core-video-player)
[![Twitter URL](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/hashtag/vueCoreVideoPlayer?src=hashtag_click)

<img width="180" src="./UI/assets/logo.png">

A Lightweight Video Player For Vue.js.


## Get Started

### Npm

``` bash
$ npm install vue-core-video-player --save
```

### Yarn

``` bash
$ yarn add vue-core-video-player --save
```


``` vue
<template>
  <div class="player-container">
    <vue-core-video-player @play="your_method" src="./videos/your_video.mp4"></vue-core-video-player>
  </div>
<template>

<script>
import VueCoreVideoPlayer from 'vue-core-video-player'

Vue.use(VueCoreVideoPlayer)

</script>
```
[View Demo](http://events.jackpu.com/vue-core-video-player-examples/)


## Docs

+ [English Document](https://core-player.github.io/vue-core-video-player/)
+ [中文文档](https://core-player.github.io/vue-core-video-player/zh/)
+ [日本語](./docs/jp/README.md)

## Features

+ Custom configuration
+ i18n
+ SSR
+ Picture-in-Picture Mode
+ Events Subscription
+ Development friendly
+ Mobile Adaptation

### Who using it

Welcome to submit your website using the package [Demo Case Collection](https://github.com/core-player/vue-core-video-player/issues/26)


## UI

<img width="720px" src="./UI/ui.png">

[Adobe XD](./UI/vue-core-video-player-xd.xd)

[Behance](https://www.behance.net/gallery/84820301/Web-VIdeo-Player)


## 💐 Contributions

+ Open pull request with improvements
+ Discuss ideas in issues

