import Vue from 'vue'
import VueRouter from 'vue-router'
Vue.use(VueRouter)

import LandingPage from "./views/LandingPage/LandingPage";
import Category from "./views/Category/Category";
import Service from "./views/Service/Service";
import Booking from "./views/Booking/Booking";
import ServiceDetail from "./views/Service/ServiceDetail";
import BookingDetail from "./views/Booking/BookingDetail";
import CategoryDetail from "./views/Category/CategoryDetail";
import Gallery from './views/Service/Gallery'
import BookingWizard from './views/Booking/BookingWizard'
import About from './views/About/About'
import ContactUs from './views/ContactUs/ContactUs'
import PrivacyPolicy from './views/PrivacyPolicy/PrivacyPolicy'
import UserFavourite from './views/Service/Userfavourite'
import TermsConditions from './views/TermsConditions/TermsConditions'
import Provider from './views/provider/Provider.vue'
import ProviderService from './views/provider/ProviderService.vue'
import HelpSupport from './views/HelpSupport/HelpSupport'
import RefundPolicy from './views/RefundPolicy/RefundPolicy'
import Blog from "./views/Blog/Blog";
import BlogDetail from "./views/Blog/BlogDetail";
import Announcement from "./views/Announcement/Announcement";
import AnnouncementDetail from "./views/Announcement/AnnouncementDetail";
import Question from "./views/Question/Question";
import JoinUs from "./views/JoinUs/JoinUs";

const routes = [
    { path: '/', name: 'frontend-home', component: LandingPage, meta: { label: '首頁' } },
    { path: '/category', name: 'category', component: Category, meta: { label: '服務類別', homeName:'服務類別', bannerType:'category' } },
    { path: '/service', name: 'service', component: Service, meta: { label: '服務項目',homeName:'服務項目' } },
    { path: '/booking', name: 'booking', component: Booking, meta: { label: '預約清單',homeName:'預約清單' } },
    { path: '/userfavourite', name: 'user-favourite', component: UserFavourite, meta: { label: '我的最愛',homeName:'我的最愛' } },
    { path: '/service-detail/:service_id', name: 'service-detail', component: ServiceDetail, meta: { label: '服務詳情',homeName:'服務' } },
    { path: '/booking-detail/:booking_id', name: 'booking-detail', component: BookingDetail, meta: { label: '預約詳情',homeName:'預約' } },
    { path: '/category-detail/:category_id', name: 'category-detail', component: CategoryDetail, meta: { label: '詳細分類',homeName:'分類' } },
    { path: '/gallery', name: 'gallery', component: Gallery, meta: { label: 'Gallery',homeName:'Gallery' } },
    { path: '/bookingwizard/:service_id', name: 'book-service', component: BookingWizard, meta: { label: '預約/服務',homeName:'服務' } },
    { path: '/about-us', name: 'about-us', component: About, meta: { label: '關於我們',homeName:'關於我們' } },
    { path: '/contact-us', name: 'contact-us', component: ContactUs, meta: { label: '聯繫我們',homeName:'聯繫我們' } },
    { path: '/privacy-policy', name: 'privacy-policy', component: PrivacyPolicy, meta: { label: '隱私權政策',homeName:'隱私權政策'} },
    { path: '/term-conditions', name: 'term-conditions', component: TermsConditions, meta: { label: '服務條款',homeName:'服務條款' } },
    { path: '/provider', name: 'provider', component: Provider, meta: { label: '機構清單' } },
    { path: '/provider-service/:provider_id', name: 'provider-service', component: ProviderService, meta: { label: '機構服務' } },
    { path: '/help-support', name: 'help-support', component: HelpSupport, meta: { label: '幫助和支援',homeName:'幫助和支援' } },
    { path: '/refund-cancellation-policy', name: 'refund-cancellation-policy', component: RefundPolicy, meta: { label: ' 退款和取消政策 ',homeName:' 退款和取消政策 ' } },
    { path: '/blog', name: 'blog', component: Blog, meta: { label: '部落格', homeName:'部落格' } },
    { path: '/blog-detail/:blog_id', name: 'blog-detail', component: BlogDetail, meta: { label: '部落格內容',homeName:'部落格' } },
    { path: '/announcement', name: 'announcement', component: Announcement, meta: { label: '最新公告', homeName:'最新公告' } },
    { path: '/announcement-detail/:announcement_id', name: 'announcement-detail', component: AnnouncementDetail, meta: { label: '最新公告詳情',homeName:'最新公告' } },
    { path: '/question', name: 'question', component: Question, meta: { label: '常見問題', homeName:'常見問題' } },
    { path: '/join_us', name: 'join_us', component: JoinUs, meta: { label: '加入我們', homeName:'加入我們' } },
];
const router = new VueRouter({
    base: process.env.BASE_URL,
    routes: routes,
    // 解決 # 字號的方法但有點問題要再修正
    mode: 'history',
})
router.beforeEach((to, from, next) => {
    const loggedIn = localStorage.getItem('user')
    window.scrollTo(0, 0);
    if (to.matched.some(record => record.meta.auth) && !loggedIn) {
        next('/login')
        return
    }

    const title = to.meta.label
    
    if (title) { 
        document.title = title
    }

    next()
})
export default router
