
<?php
    $auth_user= authSession();
?>
{{ Form::open(['route' => ['announcement.destroy', $announcement->id], 'method' => 'delete','data--submit'=>'announcement'.$announcement->id]) }}
<div class="d-flex justify-content-end align-items-center">
    @if(!$announcement->trashed())
        @if($auth_user->can('announcement edit'))
        <a class="mr-2" href="{{ route('announcement.create',['id' => $announcement->id]) }}" title="{{ __('messages.update_form_title',['form' => __('messages.announcement') ]) }}"><i class="fas fa-pen text-primary"></i></a>
        @endif

        @if($auth_user->can('announcement delete'))
        <a class="mr-2" href="javascript:void(0)" data--submit="announcement{{$announcement->id}}" 
            data--confirmation='true' data-title="{{ __('messages.delete_form_title',['form'=>  __('messages.announcement') ]) }}"
            title="{{ __('messages.delete_form_title',['form'=>  __('messages.announcement') ]) }}"
            data-message='{{ __("messages.delete_msg") }}'>
            <i class="far fa-trash-alt text-danger"></i>
        </a>
        @endif
    @endif
    @if(auth()->user()->hasAnyRole(['admin']) && $announcement->trashed())
        <a href="{{ route('announcement.action',['id' => $announcement->id, 'type' => 'restore']) }}"
            title="{{ __('messages.restore_form_title',['form' => __('messages.announcement') ]) }}"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="{{ __('messages.restore_form_title',['form'=>  __('messages.announcement') ]) }}"
            data-message='{{ __("messages.restore_msg") }}'
            data-datatable="reload"
            class="mr-2">
            <i class="fas fa-redo text-secondary"></i>
        </a>
        <a href="{{ route('announcement.action',['id' => $announcement->id, 'type' => 'forcedelete']) }}"
            title="{{ __('messages.forcedelete_form_title',['form' => __('messages.announcement') ]) }}"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="{{ __('messages.forcedelete_form_title',['form'=>  __('messages.announcement') ]) }}"
            data-message='{{ __("messages.forcedelete_msg") }}'
            data-datatable="reload"
            class="mr-2">
            <i class="far fa-trash-alt text-danger"></i>
        </a>
    @endif
</div>
{{ Form::close() }}