<x-master-layout>
    <div class="container-fluid">
        <div class="row">
        <div class="col-lg-12">
                <div class="card card-block card-stretch">
                    <div class="card-body p-0">
                        <div class="d-flex justify-content-between align-items-center p-3 flex-wrap gap-3">
                            <h5 class="font-weight-bold">{{ $pageTitle ?? __('messages.list') }}</h5>
                                <a href="{{ route('handyman.index') }}" class="float-right btn btn-sm btn-primary"><i class="fa fa-angle-double-left"></i> {{ __('messages.back') }}</a>
                            @if($auth_user->can('handyman list'))
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        {{ Form::model($handymandata,['method' => 'POST','route'=>'handyman.store', 'enctype'=>'multipart/form-data', 'data-toggle'=>"validator" ,'id'=>'handyman'] ) }}
                            {{ Form::hidden('id') }}
                            {{ Form::hidden('user_type', $handymandata->user_type) }}
                            <div class="row">
                                <div class="form-group col-md-4">
                                    {{ Form::label('first_name',__('姓名').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                    {{ Form::text('first_name',old('first_name'),['placeholder' => __('姓名'),'class' =>'form-control','required']) }}
                                    <small class="help-block with-errors text-danger"></small>
                                </div>
                                
                                {{-- <div class="form-group col-md-4">
                                    {{ Form::label('last_name',__('messages.last_name').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                    {{ Form::text('last_name',old('last_name'),['placeholder' => __('messages.last_name'),'class' =>'form-control','required']) }}
                                    <small class="help-block with-errors text-danger"></small>
                                </div> --}}
                                
                                <div class="form-group col-md-4">
                                    {{ Form::label('username',__('messages.username').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                    {{ Form::text('username',old('username'),['placeholder' => __('messages.username'),'class' =>'form-control','required']) }}
                                    <small class="help-block with-errors text-danger"></small>
                                </div>

                                <div class="form-group col-md-4">
                                    {{ Form::label('email',__('messages.email').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                    {{ Form::email('email',old('email'),['placeholder' => __('messages.email'),'class' =>'form-control','required']) }}
                                    <small class="help-block with-errors text-danger"></small>
                                </div>
                                @if (!isset($handymandata->id) || $handymandata->id == null)
                                    <div class="form-group col-md-4">
                                        {{ Form::label('password',__('messages.password').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                        {{ Form::password('password', ['class' => 'form-control', 'placeholder' => __('messages.password'), 'required']) }}
                                        <small class="help-block with-errors text-danger"></small>
                                    </div>
                                @endif
                                <div class="form-group col-md-4">
                                    {{ Form::label('handymantype_id', __('messages.select_name',[ 'select' => __('messages.handymantype') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('handymantype_id', [optional($handymandata->handymantype)->id => optional($handymandata->handymantype)->name], optional($handymandata->handymantype)->id, [
                                        'class' => 'select2js form-group handymantype',
                                        'required',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.handymantype') ]),
                                        'data-ajax--url' => route('ajax-list', ['type' => 'handymantype']),
                                    ]) }}
                                </div>
                                @if(auth()->user()->hasAnyRole(['admin','demo_admin']))
                                <div class="form-group col-md-4">
                                    {{ Form::label('provider_id', __('messages.select_name',[ 'select' => __('messages.providers') ]),['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('provider_id', [optional($handymandata->providers)->id => optional($handymandata->providers)->display_name], optional($handymandata->providers)->id, [
                                        'class' => 'select2js form-group providers',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.providers') ]),
                                        'data-ajax--url' => route('ajax-list', ['type' => 'provider']),
                                    ]) }}
                                </div>
                                @endif

                                <div class="form-group col-md-4">
                                    {{ Form::label('name', __('messages.select_name',[ 'select' => __('messages.provider_address') ]),['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('service_address_id', [], old('service_address_id'), [
                                        'class' => 'select2js form-group service_address_id',
                                        'id' =>'service_address_id',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.provider_address') ]),
                                    ]) }}
                                </div>
                                
                                <div class="col-md-8">
                                    <div class="city-selector row">
                                        <div class="col-6 form-group">
                                            {{ Form::label('name', __('messages.state',[ 'select' => __('messages.state') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                            <select id="county" required class="form-control county" name="state_id">
                                                <option value="">請選擇</option>
                                                @foreach($cities as $city)
                                                    <option value="{{ $city['value'] }}" {{ $city['value'] === $handymandata->state_id ? 'selected' : '' }}>{{ $city['text'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-6 form-group">
                                                {{ Form::label('name', __('messages.city',[ 'select' => __('messages.city') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                                <select id="city" required class="form-control city" name="city_id"></select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    {{ Form::label('address',__('messages.other_address'), ['class' => 'form-control-label']) }}
                                    {{ Form::textarea('address', null, ['class'=>"form-control textarea" , 'rows'=>1  , 'placeholder'=> __('messages.other_address') ]) }}
                                </div>

                                {{-- <div class="form-group col-md-4">
                                    {{ Form::label('country_id', __('messages.select_name',[ 'select' => __('messages.country') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('country_id', [optional($handymandata->country)->id => optional($handymandata->country)->name], optional($handymandata->country)->id, [
                                        'class' => 'select2js form-group country',
                                        'required',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.country') ]),
                                        'data-ajax--url' => route('ajax-list', ['type' => 'country']),
                                    ]) }}
                                </div>

                                <div class="form-group col-md-4">
                                    {{ Form::label('state_id', __('messages.select_name',[ 'select' => __('messages.state') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('state_id', [], [
                                        'class' => 'select2js form-group state_id',
                                        'required',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.state') ]),
                                    ]) }}
                                </div>

                                <div class="form-group col-md-4">
                                    {{ Form::label('city_id', __('messages.select_name',[ 'select' => __('messages.city') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                    <br />
                                    {{ Form::select('city_id', [], old('city_id'), [
                                        'class' => 'select2js form-group city_id',
                                        'required',
                                        'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.city') ]),
                                    ]) }}
                                </div> --}}

                                <div class="form-group col-md-4">
                                    {{ Form::label('contact_number',__('messages.contact_number').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                    {{ Form::text('contact_number',old('contact_number'),['placeholder' => __('messages.contact_number'),'class' =>'form-control','required']) }}
                                    <small class="help-block with-errors text-danger"></small>
                                </div>

                                <div class="form-group col-md-4">
                                    {{ Form::label('status',__('messages.status').' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                    {{ Form::select('status',['1' => __('messages.active') , '0' => __('messages.inactive') ],old('status'),[ 'class' =>'form-control select2js','required']) }}
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="form-control-label" for="profile_image">{{ __('messages.profile_image') }} </label>
                                    <div class="custom-file">
                                        <input type="file" name="profile_image" class="custom-file-input" accept="image/*">
                                        <label class="custom-file-label upload-label">{{  __('messages.choose_file',['file' =>  __('messages.profile_image') ]) }}</label>
                                    </div>
                                    <span class="selected_file"></span>
                                </div>

                                @if(getMediaFileExit($handymandata, 'profile_image'))
                                    <div class="col-md-2 mb-2">
                                        <img id="profile_image_preview" src="{{getSingleMedia($handymandata,'profile_image')}}" alt="#" class="attachment-image mt-1">
                                            <a class="text-danger remove-file" href="{{ route('remove.file', ['id' => $handymandata->id, 'type' => 'profile_image']) }}"
                                                data--submit="confirm_form"
                                                data--confirmation='true'
                                                data--ajax="true"
                                                data-toggle="tooltip"
                                                title='{{ __("messages.remove_file_title" , ["name" =>  __("messages.image") ]) }}'
                                                data-title='{{ __("messages.remove_file_title" , ["name" =>  __("messages.image") ]) }}'
                                                data-message='{{ __("messages.remove_file_msg") }}'>
                                                <i class="ri-close-circle-line"></i>
                                            </a>
                                    </div>
                                @endif
                                

                                <div class="form-group col-md-12">
                                    {{ Form::label('description',__('messages.description'), ['class' => 'form-control-label']) }}
                                    {{ Form::textarea('description', null, ['class'=>"form-control textarea" , 'rows'=>3  , 'placeholder'=> __('messages.description') ]) }}
                                </div>
                                @if($handymandata->gender)
                                <div class="form-group col-md-12">
                                    <label for="">性別：{{ $handymandata->gender ? '男' : '女' }}</label>
                                </div>
                                @endif
                                @if($handymandata->detail)
                                <div class="form-group col-md-12">
                                    {{ Form::label('history',__('messages.history'), ['class' => 'form-control-label']) }}
                                    {{ Form::textarea('detail', null, ['class'=>"form-control textarea" , 'rows'=>3 , 'disabled'  , 'placeholder'=> __('messages.history') ]) }}
                                </div>
                                @endif
                                @if($handymandata->skills)
                                <div class="form-group col-md-12">
                                    {{ Form::label('skills',__('messages.skills'), ['class' => 'form-control-label']) }}
                                    {{ Form::textarea('skills', null, ['class'=>"form-control textarea" , 'rows'=>3 , 'disabled' , 'placeholder'=> __('messages.skills') ]) }}
                                </div>
                                @endif
                                @if($handymandata->service)
                                <div class="col-6">
                                    <label for="">提供的服務：</label>
                                    @foreach ( $handymandata->service as $service )
                                        {{ $service }}、
                                    @endforeach
                                </div>
                                @endif
                                @if($handymandata->serviceItem)
                                <div class="col-6">
                                    <label for="">服務項目：</label>
                                    @foreach ( $handymandata->serviceItem as $serviceItem )
                                        {{ $serviceItem }}、
                                    @endforeach
                                </div>
                                @endif
                                @if($handymandata->role1)
                                <div class="col-6">
                                    <label for="">資格選填：</label>
                                    @foreach ( $handymandata->role1 as $role )
                                        {{ $role }}、
                                    @endforeach
                                </div>
                                @endif
                                @if($handymandata->role2)
                                <div class="col-6">
                                    <label for="">資格選填：</label>
                                    @foreach ( $handymandata->role2 as $role )
                                        {{ $role }}、
                                    @endforeach
                                </div>
                                @endif
                                @if(getMediaFileExit($handymandata, 'userPics'))
                                    <div class="col-12">
                                        附檔：
                                        <div>
                                            @foreach( getMutipleMedia($handymandata,'userPics') as $media)
                                                <a href="{{ $media['url'] }}" download>
                                                    <i class="fas fa-paperclip"></i> {{ $media['name'] }}
                                                </a>
                                                <br>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                            {{ Form::submit( __('messages.save'), ['class'=>'btn btn-md btn-primary float-right']) }}
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('bottom_script')
        <script type="text/javascript">
            (function($) {
                "use strict";
                $(document).ready(function(){
                    var country_id =  "{{ isset($handymandata->country_id) ? $handymandata->country_id : 0 }}";
                    var state_id = "{{ isset($handymandata->state_id) ? $handymandata->state_id : 0 }}";
                    var city_id = "{{ isset($handymandata->city_id) ? $handymandata->city_id : 0 }}";

                    var provider_id =  "{{ isset($handymandata->provider_id) ? $handymandata->provider_id : '' }}";
                    var service_address_id =  "{{ isset($handymandata->service_address_id) ? $handymandata->service_address_id : 0 }}";

                    stateName( country_id , state_id);
                    providerAddress(provider_id,service_address_id)
                    $(document).on('change' , '#provider_id' , function (){
                        var provider_id = $(this).val();
                        $('#service_address_id').empty();
                        providerAddress(provider_id,service_address_id);
                    })
                    $(document).on('change' , '#country_id' , function (){
                        var country = $(this).val();
                        $('#state_id').empty();
                        $('#city_id').empty();
                        stateName(country);
                    })
                    $(document).on('change' , '#state_id' , function (){
                        var state = $(this).val();
                        $('#city_id').empty();
                        cityName(state , city_id);
                    })
                    

                })
                function stateName(country , state ="" ){
                    var state_route = "{{ route('ajax-list', [ 'type' => 'state','country_id' =>'']) }}"+country;
                    state_route = state_route.replace('amp;','');

                    $.ajax({
                        url: state_route,
                        success: function(result){
                            $('#state_id').select2({
                                width: '100%',
                                placeholder: "{{ trans('messages.select_name',['select' => trans('messages.state')]) }}",
                                data: result.results
                            });
                            if(state != null){
                                $("#state_id").val(state).trigger('change');
                            }
                        }
                    });
                }
                function cityName(state , city =""){
                    var city_route = "{{ route('ajax-list', [ 'type' => 'city' ,'state_id' =>'']) }}"+state;
                    city_route = city_route.replace('amp;','');

                    $.ajax({
                        url: city_route,
                        success: function(result){
                            $('#city_id').select2({
                                width: '100%',
                                placeholder: "{{ trans('messages.select_name',['select' => trans('messages.city')]) }}",
                                data: result.results
                            });
                            if(city != null || city != 0){
                                $("#city_id").val(city).trigger('change');
                            }
                        }
                    });
                }
                function providerAddress(provider_id,service_address_id=""){
                    var provider_address_route = "{{ route('ajax-list', [ 'type' => 'provider_address','provider_id' =>'']) }}"+provider_id;
                    provider_address_route = provider_address_route.replace('amp;','');

                    $.ajax({
                        url: provider_address_route,
                        success: function(result){
                            $('#service_address_id').select2({
                                width: '100%',
                                placeholder: "{{ trans('messages.select_name',['select' => trans('messages.provider_address')]) }}",
                                data: result.results
                            });
                            if(service_address_id != ""){
                                $('#service_address_id').val(service_address_id).trigger('change');
                            }
                        }
                    });
                }
            })(jQuery);
        </script>
        <script src="{{ asset('js/tw-city-selector.min.js') }}"></script>
            
        <script>
            // new TwCitySelector({
            //     el: '.city-selector',
            //     elCounty: '#county', // 在 el 裡查找 element
            //     elDistrict: '#city', // 在 el 裡查找 element
            // });
            const county = document.querySelector('#county')
            const city = document.querySelector('#city')

            county.addEventListener('change', getDistrictsData )

            function getDistrictsData( district = 0 ){
                let formData = new FormData();
                formData.append('_token','{{ csrf_token() }}');
                formData.append('city', county.value)
                fetch('{{ route("getDistrictsData") }}',{
                    'method':'post',
                    'body':formData
                }).then(function (response) {
                    return response.json();
                }).then(function (result) {
                    city.innerHTML = '';
                    result.forEach(function(district) {
                        let option = document.createElement('option');
                        option.value = district.value;
                        option.text = district.text;

                        if(district){
                            option.selected = true
                        }

                        city.appendChild(option);
                    });
                })
            }
            @if($gcAddress)
                getDistrictsData()
            @endif
        </script>
    @endsection
</x-master-layout>